#uses "CtrlHTTP"
#uses "json.ctl"

// URL how the telegram http server can be reached, that includes the number and the password hash
string restUrl="https://api.telegram.org/bot<yourBotKey>/";

bool useWebHook=false;

// if useWebHook=true, URL how the telegram http server can reach our server (webhook)
string cbUrl="https://<address_and_port_of_this_webserver_from_internet_reachable/telegram_bridge";

string dp="_telegramMessage";

int lastRcvOffset = 0;

main()
{
  int ret=0;
  
//  initHosts();

//  if (getHostname() == host2)   // left host -> use right dpe
//     sAdd = "_2"; 

  dpConnect("sendMessage", 0,
            dp + ".send.number",
            dp + ".send.body",
            dp + ".send.uuid"
           );  

  if (useWebHook)
  {
    httpServer(FALSE, 89, 88);
    httpConnect("RESTcb", "/telegram_bridge");
    
    setCallbackURL();
  }
  else
  {
    deleteWebHook();
    
    while(1)
    {
      DebugTN("Telegram, longPoll()", longPoll());
    }
    
  }
}

int longPoll()
{
  mapping m=makeMapping("timeout", 100);
  
  if (lastRcvOffset > 0)
    m["offset"] = lastRcvOffset + 1;

  mapping res;

  mapping header=makeMapping("Content-Type", "application/json");
      
  int ret=netPost(restUrl+"getUpdates", makeMapping("headers", header, "content",
                                                     jsonEncode(m)), res);
//  DebugTN(ret, res);

  if (ret == 0)
  {
    if (mappingHasKey(res, "httpStatusCode") )
    {
      if (res["httpStatusCode"] == 200 )
      {
        
        if (mappingHasKey(res, "content"))
        {
          anytype data = json_strToVal(res["content"]);
          
//          DebugTN (data);
          
          if (mappingHasKey(data, "ok") && data["ok"] == 1 &&
              mappingHasKey(data, "result") )
          {
            for (int i = 1; i <= dynlen(data["result"]); i++)
            {
              if (mappingHasKey(data["result"][i], "update_id") && data["result"][i]["update_id"] > lastRcvOffset)
                lastRcvOffset = data["result"][i]["update_id"];
              
              if (mappingHasKey(data["result"][i], "message") &&
                  mappingHasKey(data["result"][i]["message"], "from") &&
                  mappingHasKey(data["result"][i]["message"]["from"], "id") &&
                  mappingHasKey(data["result"][i]["message"]["from"], "last_name") &&
                  mappingHasKey(data["result"][i]["message"]["from"], "first_name") &&
                  mappingHasKey(data["result"][i]["message"], "date") &&
                  mappingHasKey(data["result"][i]["message"], "text"))
              {
                dpSet(dp + ".receive.number", data["result"][i]["message"]["from"]["id"],
                      dp + ".receive.body", data["result"][i]["message"]["text"],
                      dp + ".receive.name", data["result"][i]["message"]["from"]["last_name"] + ", " + data["result"][i]["message"]["from"]["first_name"],
                      dp + ".receive.time", data["result"][i]["message"]["date"]);
              }    
            }
          }
        }
        return 0;
        
      }
      else
        return res["httpStatusCode"];
    }
    else
      return -2;
  }
  
  return ret;  
}

//---------------------------------------------------------------------------------------------------------------------------------------
mixed RESTcb(const mixed content, string user, string ip, dyn_string ds1, dyn_string ds2, int connIdx)
{
  string _JSON;
  blobGetValue(content, 0, _JSON, bloblen(content));
  anytype data = json_strToVal(_JSON);

  DebugTN(data);

  if (mappingHasKey(data, "message") &&
      mappingHasKey(data["message"], "from") &&
      mappingHasKey(data["message"]["from"], "id") &&
      mappingHasKey(data["message"]["from"], "last_name") &&
      mappingHasKey(data["message"]["from"], "first_name") &&
      mappingHasKey(data["message"], "date") &&
      mappingHasKey(data["message"], "text"))
  {
    dpSet(dp + ".receive.number", data["message"]["from"]["id"],
          dp + ".receive.body", data["message"]["text"],
          dp + ".receive.name", data["message"]["from"]["last_name"] + ", " + data["message"]["from"]["first_name"],
          dp + ".receive.time", data["message"]["date"]);
    
  }
  mapping result = makeMapping("ANSWER", "ALLES IN ORDNUNG");
  return json_valToStr(result);
  
}

int sendMessage(string dp1, string number, string dp2, string body, string dp3, string uuid)
{
  string json="";

  json=jsonEncode(makeMapping("chat_id", number,
                              "text", body));
//    DebugTN(json);
  mapping res;

  mapping header=makeMapping("Content-Type", "application/json");
      
  int ret=netPost(restUrl+"sendMessage", makeMapping("headers", header, "content",
                                 json), res);
  DebugTN(ret, res);

  string rettext = "";
  
  if (ret == 0 &&
      mappingHasKey(res, "httpStatusCode") &&
      res["httpStatusCode"] == 200 )
  {
    dpSet(dp + ".send.retuuid", uuid,
          dp + ".send.retcode", 0,
          dp + ".send.rettext", "");
  }
  else
  {
    dpSet(dp + ".send.retuuid", uuid,
          dp + ".send.retcode", ret,
          dp + ".send.rettext", jsonEncode(res));
  }
  
  return ret;
                 
}

int deleteWebHook()
{
  
  mapping res;

  mapping header=makeMapping("Content-Type", "application/json");

  //DebugTN(sContent);
  int ret=netPost(restUrl+"deleteWebhook", makeMapping("headers", header, "content", ""), res);
  
  DebugTN(ret, res);
/*
WCCOActrl6:         "httpStatusCode" : 200
WCCOActrl6:         "content" : "{\"ok\":true,\"result\":true,\"description\":\"Webhook was deleted\"}"
WCCOActrl6:         "url" : "https://api.telegram.org/xxx/deleteWebhook"
WCCOActrl6:         "httpStatusText" : "OK"
*/
  if (ret == 0)
  {
    if (mappingHasKey(res, "httpStatusCode") )
      if (res["httpStatusCode"] == 200 )
        return 0;
      else
        return res["httpStatusCode"];
    else
      return -2;
  }
  
  return ret;
                 
}

int setCallbackURL()
{
  
  string sFilename="";
  
  if ((sFilename=getPath(CONFIG_REL_PATH, "certificate.pem"))=="")
  {
    return -1;
  }

  string sContent="";
  fileToString(sFilename, sContent);
  //DebugTN(sFilename, sContent);
  
  mapping res;

  string boundary=createUuid();
  sContent=//"Content-Type: multipart/form-data, boundary=" + boundary + "\r\n\r\n"
           "--" + boundary + "\r\n"
           "Content-Disposition: form-data; name=\"url\"\r\n\r\n" + 
           cbUrl + "\r\n"
           "--" + boundary + "\r\n"
           "Content-Disposition: form-data; name=\"certificate\"; filename=\"certificate.pem\"\r\n"
           "Content-Type: application/octet-stream\r\n\r\n" + 
           sContent + 
           "\r\n"
           "--" + boundary + "--\r\n";

  mapping header=makeMapping("Content-Type", "multipart/form-data, boundary=" + boundary);
  //DebugTN(sContent);
  int ret=netPost(restUrl+"setWebhook", makeMapping("headers", header, "content", sContent), res);
  
    DebugTN(ret, res);

  if (ret == 0)
  {
    if (mappingHasKey(res, "httpStatusCode") )
      if (res["httpStatusCode"] == 200 )
        return 0;
      else
        return res["httpStatusCode"];
    else
      return -2;
  }
  
  return ret;
                 
}

