string telegramBaseDp = "_telegramMessage";

bool sendTelegramMessage(string number, string message, int &error, string &sErrorText)
{
  error = 0;
  sErrorText = "";
  string uuid = createUuid();
  dyn_anytype da;
  bool bTimeOut=false;
  
  dpSetAndWaitForValue(makeDynString(telegramBaseDp + ".send.uuid", telegramBaseDp + ".send.number", telegramBaseDp + ".send.body"), 
                       makeDynAnytype(uuid, number, message),
                       makeDynString(telegramBaseDp + ".send.retuuid:_online.._value"),
                       makeDynAnytype(uuid),
                       makeDynString(telegramBaseDp + ".send.retcode:_online.._value", telegramBaseDp + ".send.rettext:_online.._value"),
                       da,
                       10,
                       bTimeOut);
  
  if(bTimeOut)
  {
    error = 1;
    sErrorText = "Return function not called, counterpart not active?";
    
    return true;
  }
  else
  {
    if (da[1] == 0)
    {
      error = 0;
      sErrorText = "";
      
      return false;
    }
    else
    {
      error = da[1];
      sErrorText = da[2];
      
      return true;
      
    }
  }
}

int connectTelegramMessage(string workFunc)
{
  
  return dpConnect(workFunc, 0,
                   telegramBaseDp + ".receive.number",
                   telegramBaseDp + ".receive.name",
                   telegramBaseDp + ".receive.body",
                   telegramBaseDp + ".receive.time"
                   );  

}
