// Declaration of our DemoManager-class
#ifndef  DEMOMANAGER_H
#define  DEMOMANAGER_H

#include   <Manager.hxx>        // include/Manager
#include   <DpIdentifier.hxx>   // include/Basics

class PVSSCtrlApiManager : public Manager
{
  public:
    // Default constructor
	  PVSSCtrlApiManager();

    // Run the Manager
	  void run();

    // handle incoming hotlinks by group
    void handleHotLink(const DpHLGroup &group);

  void GetDPIdentifierByName( const char *szName, DpIdentifier &dp );


  private:
    // our exit flag. The signal handler will set it to PVSS_TRUE
  	static PVSSboolean doExit;

    // callback from signal handler
    virtual void signalHandler(int sig);

  void HandleCtrlApi( int iCtrlApiSize );

    // private Variables
    DpIdentifier  dpIdConnect;   // DP to connect to
    DpIdentifier  dpIdSet;       // DP the values are copied to

  DpIdentifier dpCorbaFloatRead;	// a float datapoint to write
  DpIdentifier dpCorbaFloatWrite;	// a float datapoint element to write
  DpIdentifier dpCorbaFloatConnect;	// a float datapoint that we connect to.
  
  DpIdentifier dpCtrlApiSize;		// Size of CtrlApi
  DpIdentifier dpCtrlApiValue;		// Value where we actually write to

};

#endif