// Our Resources administration
#include  <PVSSCtrlApiResources.hxx>
#include  <ErrHdl.hxx>

// Our static Variable
CharString  PVSSCtrlApiResources::dpNameSet     = "ExampleDP_Arg1.:_original.._value";
CharString  PVSSCtrlApiResources::dpNameConnect = "ExampleDP_Arg2.:_online.._value";


// Wrapper to read config file
void  PVSSCtrlApiResources::init(int &argc, char *argv[])
{
  begin(argc, argv);
  while ( readSection() || generalSection() )
    ;
  end(argc, argv);
}


// Read the config file.
// Our section is [demo] or [demo_<num>], 
// our keywords are "dpNameSet" and dpNameConnect
PVSSboolean  PVSSCtrlApiResources::readSection()
{
  // Is it our section ? 
  // This will test for [demo] and [demo_<num>]
  if (!isSection("demo"))
    return PVSS_FALSE;

  // Read next entry
  getNextEntry();

  // Loop thru section
  while ( (cfgState != CFG_SECT_START) &&  // Not next section
          (cfgState != CFG_EOF) )          // End of config file
  {
    // Compare keyword with "dpNameSet" and dpNameConnect
    if (!keyWord.icmp("dpNameSet"))             // It matches
      cfgStream >> dpNameSet;                   // read the value
    else if (!keyWord.icmp("dpNameConnect"))    // next keyword   
      cfgStream >> dpNameConnect;           
    else if (!readGeneralKeyWords())            // keywords handled in Resources
    {
      ErrHdl::error(ErrClass::PRIO_WARNING,     // not that bad
                    ErrClass::ERR_PARAM,        // wrong parametrization
                    ErrClass::ILLEGAL_KEYWORD,  // illegal Keyword in Res.
                    keyWord);

      // Signal error, so we stop later
      cfgError = PVSS_TRUE;
    }

    getNextEntry();
  }

  // So the loop will stop at the end of the file
  return cfgState != CFG_EOF;
}

