/**************************************************************************************************
$Header:$

Name:
	CtrlApi sample manager.

Description
	This is a sample manager that will demonstrate the
	functionality that most managers will have which is:

	1) Doing a dpSet()
	2) Doing a dpGet()
	3) Doing a dpConnect()

	This sample manager uses hardcoded datapoint names
	( which is not always a good idea ).

	The code of interest is:

	
	Getting the datapoint ID from datapoint adress:
	=================================================
		Manager::getId( szName, dp)

	Doing a dpSet()
	=================================================
		if( !dpFloatWrite.isNull() ){
		  FloatVar JustAFloat( 12.3 );
		  Manager::dpSet( dpFloatWrite, JustAFloat );
		}

	Doing a dpGet()
	Note that this is asynchronous. We pass a callback object to receive
	the actual value
	=================================================
		if( !dpFloatRead.isNull() ){
		  Manager::dpGet(dpFloatRead, new ApiGetWaitForAnswer() );
		} 

	Doing a dpConnect()
	Again asynchronous via a callback object
	=================================================
		if( !dpCtrlApiSize.isNull() ){
		  DpIdentList  dpList;			// Create a list of Dp identifiers
		  dpList.append(dpCtrlApiSize);		// Put our Dp in the list
    
		  // Create our Callback object
		  DemoHotlinkWaitForAnswer *wait = new DemoHotlinkWaitForAnswer;

		  // do the Connect
		  Manager::dpConnect(dpList, wait);
                }





Restrictions
	None
Copyright (c) 2003, ETM Benelux BV, Rosmalen, the Netherlands
***************************************************************************************************
$Log:$
**************************************************************************************************/

#include <PVSSCtrlApiManager.hxx>
#include <PVSSCtrlApiResources.hxx>

#include <Windows.h>

// Include the library that allows us to use 'Control' statement in a C++ manager
#include <CtrlApi.hxx>

void Test();


// ---------------------------------------------------------------
// Our callback class
class DemoHotlinkWaitForAnswer : public HotLinkWaitForAnswer
{
  public:
    // Answer on conenct
    void hotLinkCallBack(DpMsgAnswer &answer);
    void hotLinkCallBack(DpHLGroup &group);
};



void DemoHotlinkWaitForAnswer::hotLinkCallBack(DpMsgAnswer &answer)
{
  // cout << "Got answer" << endl;
}


void DemoHotlinkWaitForAnswer::hotLinkCallBack(DpHLGroup &group)
{
  ((PVSSCtrlApiManager *) Manager::getManPtr())->handleHotLink(group);
}



// -------------------------------------------------------------------------
// Our manager class
PVSSboolean PVSSCtrlApiManager::doExit = PVSS_FALSE;



// The constructor defines Manager type (API_MAN) and Manager number
PVSSCtrlApiManager::PVSSCtrlApiManager() 
           : Manager(ManagerIdentifier(API_MAN, Resources::getManNum()))
{
}



// Handle incoming hotlinks. 
// This function is called from our hotlink object
void PVSSCtrlApiManager::handleHotLink(const DpHLGroup &group)
{
  // Local data
  int iCtrlApiSize;

  // Print Debug information
  if (Resources::isDbgFlag(Resources::DBG_API_USR1))
	  cerr << "Receiving HotLink" << endl;

  // A group consists of pairs of DpIdentifier and values called items.
  // There is exactly one item for all configs we are connected.

  for (DpVCItem *item = group.getFirstItem(); item;  item = group.getNextItem()){
    Variable *varPtr = item->getValuePtr();

    if (varPtr){


        // if the value we received isn't a float
        // then we must convert it now.
        // Here we simply convert to float.
        // Note that the "convert" method will actually allocate 
        // a class and assign it to newVarPtr.
        Variable *newVarPtr=NULL;	
        if( varPtr->convert( FLOAT_VAR, newVarPtr ) == Variable::OK ){
          FloatVar *pFloat = (FloatVar *)newVarPtr;
          iCtrlApiSize = (int)((PVSSfloat)*pFloat);

          if( iCtrlApiSize ){
    	    cerr << "Received CtrlApi size" << iCtrlApiSize << endl;
            this->HandleCtrlApi( iCtrlApiSize );
          }

        }

        // clean up
        if( newVarPtr )
          delete newVarPtr;



    }
  }
}


// Run our demo manager
void PVSSCtrlApiManager::run()
{
	long sec, usec;

  // First connect to Data manager.
  // We want Typecontainer and Identification so we can resolve names
  // This call succeeds or the manager will exit
	connectToData(StartDpInitSysMsg::TYPE_CONTAINER | StartDpInitSysMsg::DP_IDENTIFICATION);

  // While we are in STATE_INIT we are initialized by the Data manager
  while (getManagerState() == STATE_INIT)
  {
    // Wait max. 1 second in select to receive next message from data.
    // It won't take that long...
    sec = 1;
    usec = 0;
    dispatch(sec, usec);
  }

  long lStart;
  lStart = GetTickCount();
  Test();
  long lEnd = GetTickCount();
  
  
  lEnd -= lStart;
  cerr << "Time was " << lEnd << " milliseconds" << endl;
  

  // We are now in STATE_ADJUST and can connect to Event manager
  // This call will succeed or the manager will exit
  connectToEvent();

  // We are now in STATE_RUNNING. This is a good time to connect 
  // to our Datapoints

  // Get the datapoint ID's for various DP's
//  this->GetDPIdentifierByName( "CorbaTest.Float_Read:_original.._value", dpCorbaFloatRead);
//  this->GetDPIdentifierByName( "CorbaTest.Float_Write:_original.._value", dpCorbaFloatWrite);
//  this->GetDPIdentifierByName( "CorbaTest.Float_Connect:_original.._value", dpCorbaFloatConnect);

  // Get the Dp that describes the size of the CtrlApi
  this->GetDPIdentifierByName( "CtrlApi.Size:_original.._value", dpCtrlApiSize);
  this->GetDPIdentifierByName( "CtrlApi.Value:_original.._value", dpCtrlApiValue );


  // Write a value to the DP 
//  if( !dpFloatWrite.isNull() ){
//    FloatVar JustAFloat( 12.3 );
//    Manager::dpSet( dpFloatWrite, JustAFloat );
//  }

  // get a value from a DP
//  if( !dpFloatRead.isNull() ){
//    Manager::dpGet(dpFloatRead, new ApiGetWaitForAnswer() );
//  } 

  // The dpCorbaFloatConnect is where we connect to a datapoint element.
  // That is, we want to get notified when the value changes.
  if( !dpCtrlApiSize.isNull() ){
    DpIdentList  dpList;			// Create a list of Dp identifiers
    dpList.append(dpCtrlApiSize);			// Put our Dp in the list
    
    // Create our Callback object
    DemoHotlinkWaitForAnswer *wait = new DemoHotlinkWaitForAnswer;

    // do the Connect
    Manager::dpConnect(dpList, wait);
  }

  // Now loop until we are finished
  while (1)
  {
    // Exit flag set ?
    if (doExit)
      return;

    // Wait 100 ms
    sec = 0;
    usec = 100000;
    dispatch(sec, usec);
  }
}


// Receive Signals.
// We are interested in SIGINT and SIGTERM. 
void PVSSCtrlApiManager::signalHandler(int sig)
{
  if ( (sig == SIGINT) || (sig == SIGTERM) )
	  PVSSCtrlApiManager::doExit = PVSS_TRUE;
  else
    Manager::signalHandler(sig);
}


/**************************************************************************************************
$Header:$

Name:
	PVSSCtrlApiManager::GetDPIdentifierByName

Description
	Takes the name of a datapoint and looks
	for the ID of that datapoint.
	Will print out an error message when it can't find 
	the identifier.

Returns
	None

Usage

Restrictions
	None

**********************************************************$0$*************************************/

void PVSSCtrlApiManager::GetDPIdentifierByName(
  const char *szName,
  DpIdentifier &dp
)
{
  // Local data
  char szBuffer[ 200 ];

  if( Manager::getId( szName, dp) == PVSS_FALSE){

    sprintf( szBuffer, "Can't find datapoint '%s'", szName );

    // This name was unknown.
    // The parameters are in Bascis/ErrClass.hxx
    ErrHdl::error(ErrClass::PRIO_SEVERE,      // It is a severe error
                  ErrClass::ERR_PARAM,        // wrong name: blame others
                  ErrClass::UNEXPECTEDSTATE,  // fits all
                  "PVSSCtrlApiManager",      // our file name
                  "GetDPIdentifierByName",    // our function name
                  szBuffer );
  }
}


void PVSSCtrlApiManager::HandleCtrlApi( 
  int iCtrlApiSize
)
{
  int t;

  // Set the CtrlApi request Dp back to 0
  IntegerVar SetTo0( 0 );
  Manager::dpSet( dpCtrlApiSize, SetTo0 );

  for( t=0; t < iCtrlApiSize; t++){

    IntegerVar ValueToSet( t );
    Manager::dpSet( dpCtrlApiValue, ValueToSet );
  }

}


void Test()
{
  dyn_string strList;
  string strName;

  for( int iLoop = 1; iLoop < 1000; iLoop ++)
  {

    dynClear( strList );
  
    for( int t = 1; t <= 1000; t++)
    {
      dynAppend( strList, "abcdefghijklmnopqrstuvwxyz " );
    }

    for( int i = 1; i <= dynlen( strList ); i++)
    {
      strName = strList[i];

      // Convert to uppercase
      strName = strtoupper( strName );

      strList[i] = strName;
    }

  }


  // Remove the entry at the first position
  dynRemove( strList, 1 );
}