/**************************************************************************************************
$Header:$

Name:
	CtrlApi_dyn.cxx

Description
    Functions such that we can use the 'dyn_.." functions
    of the control language

Restrictions
	None
Copyright (c) 2003, ETM Benelux BV, Rosmalen, the Netherlands
***************************************************************************************************
$Log:$
**************************************************************************************************/

#include <CtrlApi.hxx>

/**************************************************************************************************
$Header:$

Name:
	dynlen

Description
    Returns the length of a dyn_.. variable.

Returns
	a 'int' is returned.

Usage

Restrictions
	None

**********************************************************$0$*************************************/

int dynlen( 
  DynVar &var 
)
{
  return var.getArrayLength();
}

/**************************************************************************************************
$Header:$

Name:
	dynRemove

Description
    Remove an element from a dynVar

Returns
	a 'int' is returned.

Usage

Restrictions
	None

**********************************************************$0$*************************************/

int dynRemove( 
  DynVar &var, 
  int iPos 
)
{
  if( (iPos < 1 ) || (iPos > (int)var.getArrayLength() ))
    return -1;

  // Remove from the DynVar
  var.remove( iPos );

  return 0;
}

/**************************************************************************************************
$Header:$

Name:
	dynAppend

Description


Returns
	a 'int' is returned.
    The length of the array after appending a new element

Usage

Restrictions
	None

**********************************************************$0$*************************************/

int dynAppend(
  dyn_string &var,
  const char *szText
)
{

  var.append( new TextVar( szText ));

  return var.getArrayLength();
}

string dyn_string::operator[]( 
  int iIndex 
)
{
  string strEmpty = "";


  if( (iIndex < 1) || (iIndex > (int)getArrayLength()) )
    return strEmpty;

  return strEmpty;

}

int dynClear( 
  DynVar &var
)
{
  var.clear();

  return 0;
}