#include "ApiGetWaitForAnswer.hxx"

#include <AnswerGroup.hxx>
#include <DpMsgAnswer.hxx>
#include <ErrHdl.hxx>
#include <PVSSMacros.hxx>
#include <FloatVar.hxx>

void ApiGetWaitForAnswer::callBack(DpMsgAnswer &answer)
{

  int iBurstSize;

	for (AnswerGroup *grpPtr = answer.getFirstGroup(); 
	     grpPtr; grpPtr = answer.getNextGroup() )
	{
		if (grpPtr->getError())
		{
			ErrHdl::error( *( grpPtr->getError() ) );
			continue;
		}
		for (AnswerItem *itemPtr = grpPtr->getFirstItem();  itemPtr; itemPtr = grpPtr->getNextItem())
		{
			itemPtr->debug(cerr, 2);

                        Variable *newVarPtr=NULL;	
                        if( itemPtr->getValuePtr()->convert( FLOAT_VAR, newVarPtr ) == Variable::OK ){
                          FloatVar *pFloat = (FloatVar *)newVarPtr;

			  if( (PVSSfloat)*pFloat > 0.0 ){
                            iBurstSize = (int)((PVSSfloat)*pFloat);

                          }

                        }

                       // clean up
                       if( newVarPtr )
                         delete newVarPtr;


		}
	}
}

