#uses "CtrlHTTP"
#uses "json.ctl"

private bool replaceValue = true;

mapping mConnected;

main()
{
  int ret=0;
  httpServer(false, 2425, 0);
  httpConnect("websocket", "/wsdata", "_websocket_");
  
}

void websocket(mapping map) /*Function definition*/
{
  mixed any;
  anytype data;
  
  while ( httpReadWebSocket(map["idx"], any) == 0 )
  {
//    DebugTN("message received", any);
    data = json_strToVal(any);
    if (mappingHasKey(data, "type"))
    {
      
      switch(data["type"])
      {
        case "getVersionInfo": doGetVersionInfo(map["idx"], data); break;
        case "dpConnect": doDpConnect(map["idx"], data); break;
        case "dpGetPeriod": doDpGetPeriod(map["idx"], data); break;
        case "dpSet": dpDpSet(map["idx"], data); break;
        default: break;
      }
      
    }
    any = "";
  }
  
  if (mappingHasKey(mConnected, map["idx"]))
  {
    DebugTN("Disconnect all connected DPEs");
    for (int i = 1; i <= mappinglen(mConnected[map["idx"]]); i++)
    {
      mapping m=mappingGetValue(mConnected[map["idx"]], i);
      DebugTN("dpDisconnectUserData", "sendDpConnectData", m, m["dpe"]);
      dpDisconnectUserData("sendDpConnectData", m, m["dpe"]);

    }
  
    mappingRemove(mConnected, map["idx"]);
  }
  DebugTN("webSocket closed");
}

int doDpSet(int idx, const mapping &data)
{
  if (mappingHasKey(data, "dpe") &&
      mappingHasKey(data, "value"))
  {
    string sDpe = data["dpe"];
    
    if (replaceValue) strreplace(sDpe, ".value", ".cmd");
    
    DebugTN("dpSet", idx, sDpe, data["value"]);
    dpSet(sDpe, data["value"]);
    dyn_errClass err;
 
    err = getLastError();
    if(dynlen(err) > 0) throwError(err);
  }    
}

int doDpGetPeriod(int idx, const mapping &data)
{
  if (mappingHasKey(data, "dpe") &&
      mappingHasKey(data, "time"))
  {
  
    int mod;
    string modtype;
  
    if (sscanf(data["time"], "%d%s", mod, modtype) != 2)
    {
      DebugTN("could not parse datetime modifier", data["time"]);
    }
    else
    {
      time tto=getCurrentTime();
    
      int y=year(tto), mo=month(tto), d=day(tto), h=hour(tto), m=minute(tto), s=second(tto);
    
      switch(modtype)
      {
        case "h": h-=mod; break;
        case "i": m-=mod; break;
        case "s": s-=mod; break;
        case "d": d-=mod; break;
        default: DebugTN("unknown modifier, using default 1h", modtype);
                 h-=1;
                 break;
      }
    
      time tfrom=makeTime(y, mo, d, h, m, s);    
      DebugTN(tfrom, tto);
    
      dyn_anytype da;
      dyn_time dt;
      int ret;
 
      // TODO at the moment only offline value is queried
      DebugTN("dpGetPeriod", tfrom, tto, data["dpe"]);
      ret = dpGetPeriod(tfrom, tto, 1, data["dpe"], da, dt);                
      if ((ret== 1) || (dynlen(da) == 0))
      {
        DebugTN("error on dpGetPeriod");
      }
      else
      {
        mapping m;
  
        m["type"] = data["type"];
        m["dpe"] = data["dpe"];
        m["values"] = da;
        m["times"] = dt;
//        m["from"] = tfrom;
//        m["to"] = tto;
        
  
        DebugTN("send dpGetPeriod Result", m, httpWriteWebSocket(idx, jsonEncode(m)));

      }
    }
  }
}

int doDpConnect(int idx, const mapping &data)
{
  if (mappingHasKey(data, "dpe"))
  {
    if (!mappingHasKey(mConnected, idx))
      mConnected[idx]=makeMapping();
    
    if (mappingHasKey(mConnected[idx], data["dpe"]))
    {
      // TODO verify if current value should really not be sent just once again
      DebugTN("doDpConnect", "already connected for connection", idx, data["dpe"]);
    }
    else
    {
      dyn_errClass err;
      DebugTN("doDpConnect", idx, data["dpe"]);
        
      // store queried name to make it also work with CNS names in the connect work function
      mapping ud = makeMapping("idx", idx, "dpe", data["dpe"]);
      dpConnectUserData("sendDpConnectData", ud, true, data["dpe"]);
 
      err = getLastError();
      if(dynlen(err) > 0) throwError(err);
      else
      {
        mConnected[idx][data["dpe"]]=ud;
          
      }
    }
    
  }    
  //DebugTN(data);
}

void sendDpConnectData(mapping ud, string sDpe, anytype data)
{
  mapping m;
  
  m["type"] = "dpConnect";
  m["dpe"] = ud["dpe"];
  m["value"] = data;
  
  DebugTN("send value change", m, httpWriteWebSocket(ud["idx"], jsonEncode(m)));
  
}

int doGetVersionInfo(int idx, const mapping &data)
{
  mapping m;
    
  m["type"] = data["type"];
  m["VERSION_DISP"] = getVersionInfo("VERSION_DISP");
  m["time"] = formatTime("ISO", getCurrentTime());
  
  DebugTN("send message back", m, httpWriteWebSocket(idx, jsonEncode(m)));
}

