// int panelpos=1;

string PD_getDPfromCNS(string identifier)
{
  string sDP;

  if(!cns_isNode(identifier) && !cnsGetId(identifier,sDP))
    return identifier;//identifier ist schon ein DP-Name
  if((cns_isNode(identifier) || cnsGetId(identifier,sDP)) && (sDP != ""))
    return strrtrim(sDP,".");//dem identifier ist ein DP zugeordnet

  dyn_string cnsChildren;
  
  cnsGetChildren(identifier,cnsChildren);
  for(int i = 1; i <= dynlen(cnsChildren); i++)
  {
    if(cnsGetId(cnsChildren[i],sDP))
    {
      if((sDP != "") && (dpTypeName(dpSubStr(sDP,DPSUB_SYS_DP)) == "Device"))
        return strrtrim(sDP,".");
    }
  }
  return "";
}

PD_initState(string sDPE)
{
  dpConnect("PD_CB_state",TRUE,sDPE+":_original.._value",
                               sDPE+":_alert_hdl.._act_state_color"
           );
}

PD_initBarState(string sDPE)
{
  dpConnect("PD_CB_barState",TRUE,sDPE+":_original.._value",
                               sDPE+":_alert_hdl.._act_state_color"
           );
}

PD_CB_barState(string dp, anytype value, string dpAlert, string color)
{
  /*
  $INT_STATE
  1 = OK
  2 = WARNING
  3 = ERROR
  ELSE = UNKNOWN
  */  
  switch(value)
  {
    case 1 : PD_setBarState("OK",color);      break;
    case 2 : PD_setBarState("WARNING",color); break;
    case 3 : PD_setBarState("ERROR",color);   break;
    default: PD_setBarState("HELP",color);    break;
  }
}

PD_setBarState(string state, string color)
{
  setMultiValue("RECTANGLE1","backCol",color,
                "rec_icon_state","fill","[pattern,[fit,any,svg/Siemens/"+state+".svg]]");
}

PD_initBarValue(string sDPE)
{
  string sDescription = dpGetDescription(sDPE,0);
  langString lsUnit = dpGetUnit(sDPE);
  
  setMultiValue("valuedescription","text",(sDescription == dpSubStr(sDPE,DPSUB_DP_EL))?"":sDescription,
                "unit","text","%");//(lsUnit!="")?lsUnit:"");
  dpConnect("PD_CB_barValue2",TRUE,sDPE);
  PD_initValue(sDPE);  
}

PD_CB_barValue2(string dp, anytype value)
{
  int w = width,
      h = height*(value/fMax);
  if(h <= height)
    setValue("RECTANGLE1","size",w,h);
}

PD_initTitle(string sDP, string sTitle)
{
  string sDescription;
  
  if(sTitle != "")
  {
    PD_setTitle(sTitle);
  }
  else if((sDescription = dpGetDescription(sDP)) != "")
  {
    PD_setTitle(sDescription);
  }
  else
  {
    PD_setTitle("UNKNOWN");
  }
}

PD_initValue(string sDPE)
{
  string sDescription = dpGetDescription(sDPE,0);
  if((sDescription != "") && (sDescription != dpSubStr(sDPE,DPSUB_DP_EL)))
  {
    string sUnit = dpGetUnit(sDPE);
    setMultiValue("txt_value_desc","text",sDescription,
                  "txt_unit","text",sUnit);
  }
  string sFormat = dpGetFormat(sDPE);
  int iFormat = getType(sDPE);
  
  if(sFormat == "") 
  {
    if(iFormat == FLOAT_VAR) setValue("txt_value","format","%7.2f");
    else if(iFormat == INT_VAR) setValue("txt_value","format","%04d");
    else setValue("txt_value","format","%s");
  }
  else
    setValue("txt_value","format",sFormat);

  dpConnect("PD_CB_value",TRUE,sDPE); 
}

PD_CB_value (string dp, float value)
{
  PD_setValue(value);  
}

PD_CB_state (string dp, int value, string dpAlert, string color)
{
  /*
  $INT_STATE
  1 = OK
  2 = WARNING
  3 = ERROR
  ELSE = UNKNOWN
  */
  switch (value)
  {
    case 1:   PD_setState("OK",color);       break;       
    case 2:   PD_setState("WARNING",color);  break;
    case 3:   PD_setState("ERROR",color);    break;
    default : PD_setState("UNKNOWN",color);  break;    
  }    
}

PD_setState(string state, string color="UNKNOWN")
{
  setMultiValue("tri_l_state","backCol",color,
                "rec_l_state","backCol",color,
                "txt_state","foreCol",state,
                "txt_state","text",getCatStr("KeyVisual",state),
                "rec_icon_state","fill","[pattern,[fit,any,svg/Siemens/"+state+".svg]]");
}

PD_setValue(anytype value)
{
  setValue("txt_value","text",value);
}

PD_setTitle(string title)
{
  setValue("txt_title","text",title);
}

PD_initBitmap(string sDPE)
{
  if(dpExists(sDPE))
    dpConnect("PD_CB_bitmap",TRUE,sDPE);
}

PD_CB_bitmap(string dp, string value)
{
  PD_setBitmap(value);
}

PD_setBitmap(string sBitmap)
{
  setValue("RECTANGLE8","fill","[pattern,[fit,any,"+sBitmap+"]]");
}

PD_initCircle(string sDPE,string sColorValue, string sColorBack)
{
  setMultiValue("kreis","backCol",sColorValue,
                "vollkreis","foreCol",sColorBack);
  dpConnect("PD_CB_circle",TRUE,sDPE);
}

PD_CB_circle(string dp, float value)
{
  float angle = value;
  while(angle > fMax) angle = angle - fMax;
  angle = (angle / (fMax - fMin)) * 360.0;
  
  kreis.angle2(angle);
}

PD_initIcon(string sDP)
{
//   setValue("numbers","visible",FALSE);
  dpConnect("PD_CB_bitmap",TRUE,$DP+".config.type");
  setValue("RECTANGLE8","visible",TRUE);
}

PD_initInvalid(string sDPE, bool bInvalid)
{
  if(bInvalid)
    dpConnect("PD_CB_invalid",TRUE,sDPE+":_original.._bad");
  
  string sDescription = dpGetDescription(sDPE,0);
  langString lsUnit = dpGetUnit(sDPE);
  
  setMultiValue("valuedescription","text",(sDescription == dpSubStr(sDPE,DPSUB_DP_EL))?"":sDescription,
                "unit","text",(lsUnit!="")?lsUnit:"");
}
    
PD_CB_invalid(string dp, bool bInvalid)
{
  setValue("invalid","visible",bInvalid);
}

PD_initGauge(string sDP)
{
  if(dpExists(sDP+".input.analog.value"))
  {
    langString lsUnit = dpGetUnit(sDP+".input.analog.value");
    if(lsUnit != "") Gauge.unit = lsUnit;
    
    int numRanges;
    dyn_anytype limit;
    dyn_string class1,color;
    string sTemp;
    anytype aTemp;
    
    dpGet(sDP+".input.analog.value:_alert_hdl.._num_ranges",numRanges);
    
    for(int i = 1; i <= numRanges; i++)
    {
      dpGet(sDP+".input.analog.value:_alert_hdl."+i+"._u_limit", limit[i],
            sDP+".input.analog.value:_alert_hdl."+i+"._class", class1[i]);
      if ( class1[i] != "" )
      dpGet(class1[i]+":_alert_class.._color_c_ack",color[i]);
    }
    
    for(int i = 1; i <= numRanges; i++)
    {
      if (class1[i] != "")
      {                
        if(i == 1) Gauge.addMarking((float)Gauge.minimum(),(float)limit[1],color[1]);
        else if(i < numRanges) Gauge.addMarking((float)limit[i-1],(float)limit[i], (string)color[i]);
        else Gauge.addMarking((float)limit[numRanges-1],(float)Gauge.maximum(),(string)color[numRanges]);
      }
      else 
      {
        Gauge.addMarking((float)limit[i-1],(float)limit[i], "OK");
      }
    }

    dpConnect("PD_CB_setGauge",TRUE,sDP+".input.analog.value");
  }
}

PD_CB_setGauge(string dp, anytype value)
{
  Gauge.value=value;
}

PD_UserPopup()
{
  dyn_string popUpEntries;
  int answer;
  string dp,user;  
  time tStime;
  string checkPerm="1",checkUser="0";
  int x, y;
  dyn_int di;

  
  if ( !getUserPermission(4) ) // Permision check
   checkPerm="0";
  
  
  if(getUserName()!= "")
   checkUser="1";
 
  popUpEntries = makeDynString(// Open login panel
                               "PUSH_BUTTON," +getCatStr("STD", "Text4") + " , 1,1", 
                               // Logout User
                               "PUSH_BUTTON," +getCatStr("STD", "Text5") + ", 2, "+checkUser,  
                               "PUSH_BUTTON," +getCatStr("STD", "Text13") + ", 6, "+checkPerm,  
                               "SEPARATOR",                       // Seperator line
                               "CASCADE_BUTTON, Info, 1",         // Forked: Sub-popup
                               // Open user definition dialog (if allowed)
                               "PUSH_BUTTON, " +getCatStr("STD", "Text6") + ", 3, "+checkPerm,   
                               "SEPARATOR",                       // Seperator line
                               "PUSH_BUTTON, " +getCatStr("STD", "changepassword") + ", 7, 1",   
                               "Info",                            // From here it's the Sup-popup
                               "SEPARATOR",                       // Seperator line
                               "PUSH_BUTTON, " +getCatStr("STD", "Text7") + ", 4, 1",
                               "PUSH_BUTTON, " +getCatStr("STD", "Text8") + ", 5, 1");

  popupMenu(popUpEntries,answer);
 
  //DebugN("PopUpEntry clicked: "+answer);

  dp = myUiDpName() + "."; 
  dpGet(dp+"UserName:_online.._stime",tStime,
        dp+"UserName:_online.._value",user); 


   switch(answer)
  {
    case 1: ChildPanelOnCentralModal("vision/login.pnl", 
                                    getCatStr("STD", "Text6"), makeDynString(""));
            return;
    case 2: STD_LogoutCurrentUser();
            return;
    case 3: ChildPanelOnCentralModal("vision/ud_main.pnl", 
                                    getCatStr("STD", "Text6"), makeDynString());
            return;

    case 4: ChildPanelOnCentralModal("vision/MessageInfo1",getCatStr("STD", "Text9"),
                                    makeDynString(getCatStr("STD", "Text7")+": "
                                    +formatTime("%c",tStime) ));
            return;
 
    case 5: ChildPanelOnCentralModal("vision/UserConnections",getCatStr("STD", "Text8"),
                                    makeDynString());
            return;
    case 6: //msc_createFav(getUserName(), "lastScreenView");
            STD_CloseUis();
            return;          
    case 7: ChildPanelOnCentralModal("vision/changePassword.pnl",getCatStr("STD", "changepassword") ,
                                    makeDynString());
            return;          

    default: return;
  }

}




void setPanel(int pos)
{
  dyn_string dsNodes;
  int len;  
  
  dpGet("_PanelTopology.nodeName",dsNodes);
  len = dynlen(dsNodes);
  if(pos > 0 && pos < len)
  {
    setValue("TEXT1","text",dsNodes[pos]);
    pt_panelOn3(pos,"mainModule_1");
  }
  else 
    panelpos =1;
}
