// Universal Simulation of Values
/*
   B.Lange  2014.10.10
   
   Data Source is a file  PROJ_PATH + DATA_REL_PATH+ "Simulation.dat"
   this defines the simulations of values
   The 1.st Line of the file is only for enhancing the human readability but will be ignored.  
   The delimiter is set to ";" for easy Excel editing of the table but can be changed 
   
   File Format
   ----------------------------------------------------------------------------------
   Header  + DP     ; Intervall ;   min    ;    max   ; deltamin   ; deltamax   ; mode
   RAND    + DPName ; Intervall ;   Min    ;    Max   ; Min Change ; Min Change ; RAND
   BIN     + DPName ; Intervall ; not used ; not used ; not used   ; not used   ; BIN
   TIME    + DPName ; Intervall ; not used ; not used ; not used   ; not used   ; TIME
   RAMP    + DPName ; Intervall ;   Min    ;    Max   ;   Step     ; not used   ; RAMP
   SIMXX   + DPName ; Intervall ;   Min    ;    Max   ; Min Change ; Min Change ; SIMXX
   
   Note:   SIMXX XX follows the same principle as rand but the base for the change will 
           be any other Simulation and not the last value, XX indi the line number in 
           the definition file 0 is invalid/the header
               
   Further development:
   
   add a definition line above
   Example:
  
   NEW    + DPName ; Intervall ;   Min    ;    Max   ; Min Change ; Min Change ; NEW   
   
   in the switch statement add:

   case "NEW": // New function 
     
      <the code> 
      < usable variables :    fValue      the last value            >
      <                       fNewValue   the new value to be set   >
      <                       fMin        the smallest value        >
      <                       fMax        the largest value         >
      <                       fMinChange  the minmal change of value>
      <                       fMaxChange  the maxmal change of value>
      < the fNewValue should be set before break                    >      
    break;       
*/
// Global Values
dyn_float dfLastValue;
dyn_dyn_string ddsSimParameter;
const int demo_init  = 10;
const int demo_work  = 11;
const int demo_trace = 12;

main()
{
  
  string sFileName = PROJ_PATH + DATA_REL_PATH+ "Simulation.dat"; // filename with parameters
  string sDelimiter = ";";   // delimiter for file
  string sTimername = "_simulationTimer"; // name of timer
  int iIntervall = 1;  // interval of timer 
  ddsSimParameter = sim_readParameter(sFileName,sDelimiter);
  sim_checkParameter();
  sim_createDp(sTimername,iIntervall);    
  sim_getStates();
  //sim_connectTimer(sTimername);  
  // Up and Running

  // simsalabim comment this out
  time tt;
    
  while (true)
  {
     tt = getCurrentTime();
     sim_output(sTimername, tt,tt);
     delay(0,900);
  }
}

// Callback Routine
void sim_output(string sDp, time tLast,time tNow)
{
  int iSecs,iTemp; // seconds total
  
  iSecs = tNow;
  // loop through simulations
  for (int i = 1; i<=dynlen(ddsSimParameter);i++)
  {
    iTemp = ddsSimParameter[i][2];
    if ( iSecs % iTemp == 0) 
    {
      // at the right time call simulation
      sim_simulateValue(i);
    }
  }  
}
  
// simulate a single value  
void sim_simulateValue(int iSimNum)  
{
  float fValue,fNewValue; 
  float fRand,fMin,fMax,fMinChange,fMaxChange,fRange;
  string sMode;
  int iTime,iNumSi;
  time tTime;   
  tTime = getCurrentTime();
  iTime = tTime;
  fMin = ddsSimParameter[iSimNum][3];
  fMax = ddsSimParameter[iSimNum][4];
  fMinChange = ddsSimParameter[iSimNum][5];
  fMaxChange = ddsSimParameter[iSimNum][6];
  // get the last value
  fValue = dfLastValue[iSimNum];
  // decide method   
  sMode = ddsSimParameter[iSimNum][7];
  // check for cascading mode  
  if (strpos(sMode,"SIM")>= 0)
  { 
    strreplace(sMode,"SIM","");
    iNumSi = (int)sMode;
    sMode = "SIM";
  }         
  
  switch(sMode)
  { 
    case "RAND": //Random Function
      fRand = (float)rand();
      fRand = fRand / 32767; // frand = 0-1
      fRange = fMaxChange - fMinChange;
      fRand = fRand * fRange;
      fRand = fRand + fMinChange;        
      fNewValue = fValue + fRand;
      if ( fNewValue < fMin ) 
      {
        fNewValue = fMin ;  
      }
       
      if ( fNewValue > fMax ) 
      {
        fNewValue = fMax ;  
      }
    break;

    case "SIM": //Random Function cascaded
      if(iNumSi < 1 || iNumSi > dynlen(ddsSimParameter))
      {
        // no calculation now
        break;
      }         
      fValue = dfLastValue[iNumSi]; 
      fRand = (float)rand();
      fRand = fRand / 32767; // frand = 0-1
      fRange = fMaxChange - fMinChange;
      fRand = fRand * fRange;
      fRand = fRand + fMinChange;        
      fNewValue = fValue + fRand;
      if ( fNewValue < fMin ) 
      {
        fNewValue = fMin ;  
      }
       
      if ( fNewValue > fMax ) 
      {
        fNewValue = fMax ;  
      }
    break; 
    
    case "BIN": //Binary Toggle should be casted to bin no other parameters  
      if (fValue == 0) 
      {
        fNewValue = 1.0;
      }
      else
      {
        fNewValue = 0.0;
      }
    break; 
        
    case "TIME": //Time as Number for sync purposes
      fNewValue = iTime;  
    break; 
    
    case "RAMP": //Time as Number for sync purposes
    // if next val larger max > start val
    if (fValue + fMinChange > fMax)
    {
      fNewValue = fMin;
      break;
    }
    // if last val smaller min > start val
    if (fValue <  fMin)
    {
      fNewValue = fMin;
      break;
    }
    
    // normal ramping
    if (fMinChange >=0 )
    {
    fNewValue = fValue + fMinChange; 
    } 
    else 
    {
      fNewValue = fValue;
      DebugFTN(demo_trace,"DP "+ddsSimParameter[iSimNum][1] + "no negative ramping");
    }
    break; 
    
    
  default:    // do nothing

   DebugFTN(demo_trace,"DP "+ddsSimParameter[iSimNum][1] + "undefined Mode");

  } 

  DebugFTN(demo_trace,"DP "+ddsSimParameter[iSimNum][1]+ " will be set to " +fNewValue );
  dpSet (ddsSimParameter[iSimNum][1],fNewValue);
  // save last value
  dfLastValue[iSimNum] = fNewValue;
}



// Clean up Parameters
void sim_checkParameter()
{
  dyn_dyn_string ddsData;
  for (int i = 1; i<=dynlen(ddsSimParameter);i++)
  { 
    // checks
    // dp 
    if (!dpExists(ddsSimParameter[i][1]))      
    {
      DebugFTN(demo_init,"Input File Line "+(i+1)+ "DP not exists");
      continue;
    }
    if ((ddsSimParameter[i][2]< 1)||(ddsSimParameter[i][2] > 60))      
    {
      DebugFTN(demo_init,"Input File Line "+(i+1)+ "Interval < 1 OR > 60");
      continue;
    }
    if (ddsSimParameter[i][3] >= ddsSimParameter[i][4])      
    {
      DebugFTN(demo_init,"Input File Line "+(i+1)+ "min >= max");
      continue;
    }
    // add some more here
    
    // append to list 
    dynAppend(ddsData,ddsSimParameter[i]);
  }
  //and save
  ddsSimParameter = ddsData;
  DebugFTN(demo_init,"File checked  " + dynlen(ddsSimParameter) + " simulations found");
}

// Connect Timer
void sim_connectTimer(string sTimerDp)
{
  string sDpName;
  dyn_errClass err;
  
  
    DebugFTN(demo_init,"Activating simulation timer ...");
    timedFunc("sim_output",sTimerDp);
    err = getLastError();
    if(dynlen(err) > 0) 
    { 
      DebugFTN(demo_init,"Activating simulation for " + sTimerDp +"failed");
    }
} 

// get old states    
void sim_getStates()
{
  float fValue;
  for (int i = 1; i<=dynlen(ddsSimParameter);i++)
  {
    dpGet( ddsSimParameter[i][1],fValue);
    dynAppend(dfLastValue,fValue);
  } 
  DebugFTN(demo_init,"Start Values loaded ");
}

// read the parameters
dyn_dyn_string sim_readParameter(string sFileName,string sDelimiter)
{
  dyn_string temp ;
  dyn_dyn_string ddsData;
  int iResult;
  iResult = sim_fileToTable(ddsData,sFileName,sDelimiter);
  // remove 1st line due to header
  dynRemove(ddsData,1);
  DebugFTN(demo_init,"File read with " + dynlen(ddsData) + " lines ");
  return ddsData;
}


// create the required dp and parametrize 
void sim_createDp(string sDpName,int iInterval)
{
  if (!dpExists(sDpName))
  {  
    dpCreate(sDpName,"_TimedFunc");
    delay(0,50); 
  }    
  // parametrize dp always
  DebugFTN(demo_init,"Parametrize Timer with interval = " + iInterval);
  dpSet(sDpName+".interval",iInterval);
  dpSet(sDpName+".syncTime",-1); 
}




// read the parameter file 
// this function reads a file into a dyn dyn table   
// @author D.Hegewisch / modified BL 09.10.2014
// @version 14.10.1998
// @param table the result Table 
// @param fileName the filename of the source file
// @param separator  the field separator 
// @return lines read or negative on errors
int sim_fileToTable(dyn_dyn_string &table, string fileName, char separator)
{
file   dataFile;    // Datenfile Handling
int    zeilen;      // Anzahl der eingelesenen Zeilen
string daten;     // Datenzeile
int    i, iPos, iIndex, iLenStr;  
string strNew, strSmall;  

  // Table deletion 
  dynClear(table);
  // Open file
  dataFile= fopen(fileName, "r");
  if (ferror(dataFile)) // on errors
  {
    DebugFTN(demo_init,"File Error: #"+ferror(dataFile)+" in File: "+fileName);
    // close file
    fclose(dataFile);
    return(-1);         // errorcode #-1 
  }

  // read to eof
  while (!feof(dataFile))
  {
    fgets(daten, 1000000, dataFile);

    // if data available
    if (daten!="")
    {
      zeilen++;
      iIndex = 1;  
      iPos   = 1;  

      while (iPos >= 0 )    
      {   
        // Position of delimiter and remove it 
        iPos=strpos(daten, separator);  
        strSmall = substr(daten,0,iPos);  
        if(iPos!=-1) 
          table[zeilen][iIndex] = strSmall; 
        else
          // remove last CR
          table[zeilen][iIndex] = strrtrim(daten, "\n\r");
 
        // new rest string  
        iLenStr = strlen(daten);  
        strNew = substr(daten,iPos+1,iLenStr-iPos);   
        daten = strNew; 

        // next Index 
        iIndex++;  
      }    // off while (iPos>=0)
    }    // off Data available
  }    // off Data reading
 
  // close the file
  fclose(dataFile);
  return(zeilen);       // return number of lines
}

