#ifndef _TcpServer_H_
#define _TcpServer_H_

#include <CtrlModule.hxx>
#include <CharString.hxx>
#include <Bcm.h>
#include <MsgItcDispatcher.hxx>
#include <Socket.hxx>
#include <ServerSocket.hxx>

//--------------------------------------------------------------------------------

class TcpServer;

class MyServerItcIOHandler : public itcIOHandler
{
  private:
    class  ItcConnection: public itcConnection
    {
      public:
        ItcConnection() : itcConnection(-1, itcConnection::ItcActive) {}
       ~ItcConnection() {itcConnection::td = -1;}
        void setFd(int fd) {itcConnection::td = fd;}
    } conn;

  public:
    MyServerItcIOHandler(TcpServer *s) : server(s) { }

    void link(Socket *ptr, itcDispatcher::itcDispatcherMask mask)
    {
      if ( ptr->isValid() )
      {
        conn.setFd(ptr->getFd());
        MsgItcDispatcher::instance()->link(&conn, (char *) ptr, mask, this);
      }
    }

    virtual int inputReady(itcConnection *conn, char *data);

  private:
    TcpServer *server;
};

//--------------------------------------------------------------------------------

class TcpServer : public CtrlModule
{
  public:
    TcpServer(CtrlScript *script, unsigned short port, const CharString &func);

    virtual ~TcpServer() {};

    /** starts the functionality.
        returns EXEC_OK if the module continues its work,
        EXEC_DONE if it has already completed and
        EXEC_ERROR if it failed to start
      */
    virtual ExecReturn start();

    /// tells, when we have to call work() at the latest again
    virtual const TimeVar &nextWork() const;

    /// give the module time to work
    virtual ExecReturn work(PVSSlong micro);

    virtual const char *className() const { return "TcpServer"; }

    void incomingConnection();

  private:
    CharString callback;
    MyServerItcIOHandler ioHandler;
    ServerSocket server;
};

#endif
