#include <TcpServer.hxx>
#include <ErrHdl.hxx>
#include <RecVar.hxx>
#include <IntegerVar.hxx>
#include <TextVar.hxx>
#include <CtrlThread.hxx>
#include <Controller.hxx>
#include <PVSSMacros.hxx>
#include <TcpSocket.hxx>

//--------------------------------------------------------------------------------

int MyServerItcIOHandler::inputReady(itcConnection *conn, char *data)
{
  server->incomingConnection();
  return 0;
}

//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------

TcpServer::TcpServer(CtrlScript *script, unsigned short port, const CharString &func)
  : CtrlModule(script), callback(func), ioHandler(this)
{
  if ( server.open(port, PVSS_TRUE) < 0 )
  {
    okFlag = PVSS_FALSE;
    ErrHdl::error(ErrClass::PRIO_WARNING, ErrClass::ERR_CONTROL, "",
                  ErrClass::SERVERSOCKET_OPEN_ERROR, CharString((int)port),
                  server.getCompletionSysCodeString());
    return;
  }
  ioHandler.link(&server, itcDispatcher::ItcReadMask);
}

//--------------------------------------------------------------------------------

ExecReturn TcpServer::start()
{
  if ( ! okFlag )
    return EXEC_DONE;

  return EXEC_OK;
}

//------------------------------------------------------------------------------

const TimeVar &TcpServer::nextWork() const
{
  return TimeVar::MaxTimeVar;
}

//------------------------------------------------------------------------------

ExecReturn TcpServer::work(PVSSlong )
{
  return EXEC_OK;
}

//--------------------------------------------------------------------------------

void TcpServer::incomingConnection()
{
  DEBUG_WORK("incomingConnection");

  TcpSocket socket;  // will be closed when exiting this method

  CharString host;
  unsigned short port;
  if ( server.accept(host, port, socket) )
  {
    // read data
    socket.recvBuffer();
    int len = socket.recvBufferLen();
    char *buffer = new char[len + 1];
    int bytes;
    socket.recv(buffer, len, 0, bytes);
    buffer[bytes] = 0;

    // start callback
    RecVar vars;
    vars.append(new TextVar(buffer));
    vars.append(new TextVar(host));

    delete [] buffer;

    CtrlThread *thread = 0;
    CtrlFunc *func = Controller::thisPtr->findFunc(callback, script);
    script->startThread(thread, func, &vars);
  }
}

//--------------------------------------------------------------------------------
