#ifndef _QtQuickWidget_h_
#define _QtQuickWidget_h_

#include <BaseExternWidget.hxx>

#include <QQuickWidget>
#include <QJSValue>

//--------------------------------------------------------------------------------

class QuickWidget : public QQuickWidget
{
  Q_OBJECT

  Q_PROPERTY(QUrl source READ source WRITE setSource DESIGNABLE true)

  public:
    QuickWidget(QWidget *parent) : QQuickWidget(parent) {}

    void setSource(const QUrl &url);

  signals:
    void genericSignal(const QString &name, const QJSValue &value);
};

//--------------------------------------------------------------------------------
// this is the EWO interface class

class EWO_EXPORT QtQuickWidget : public BaseExternWidget
{
  Q_OBJECT

  public:
    QtQuickWidget(QWidget *parent);

    virtual QWidget *widget() const;

    virtual QStringList signalList() const;
    virtual QStringList methodList() const;

  public slots:
    virtual QVariant invokeMethod(const QString &name, QList<QVariant> &values, QString &error);

  private slots:
    void statusChanged(QQuickWidget::Status status);
    void sceneGraphError(QQuickWindow::SceneGraphError error, const QString &message);
    void genericSlot(const QString &name, const QJSValue &value);

  private:
    QQuickWidget *quickWidget;
};

#endif
