#include <QtQuickWidget.hxx>
#include <QmlDp.hxx>
#include <Resources.hxx>
#include <QtUtils.hxx>
#include <iostream>

#include <QQmlError>
#include <QDebug>
#include <QtQml>
#include <QQuickItem>

//--------------------------------------------------------------------------------

EWO_PLUGIN( QtQuickWidget )

//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------

void QuickWidget::setSource(const QUrl &url)
{
  CharString fileName = PVSSFileSys::fileExists(Resources::getDataDir, QtUtils::actLangEncoded(url.path()), 0, this);
  if ( fileName.isEmpty() )
    return;

  QQuickWidget::setSource(QUrl::fromLocalFile(UTF8Converter::actLangDecoded(fileName)));
}

//--------------------------------------------------------------------------------
//--------------------------------------------------------------------------------

QtQuickWidget::QtQuickWidget(QWidget *parent)
  : BaseExternWidget(parent)
{
  quickWidget = new QuickWidget(parent);
  quickWidget->setResizeMode(QQuickWidget::SizeRootObjectToView);

  connect(quickWidget, &QQuickWidget::statusChanged, this, &QtQuickWidget::statusChanged);
  connect(quickWidget, &QQuickWidget::sceneGraphError, this, &QtQuickWidget::sceneGraphError);

  setProperty("inGedi", false);

  qmlRegisterType<QmlDp>("at.etm.WinCC_OA", 1, 0, "Datapoint");

  QStringList paths;

  for (int i = 1; i <= Resources::getSearchPathLen(); i++)
  {
    CharString path = Resources::getDataDir(i) + "qml";
    FileSys::setPathCharInString(path);
    paths.append(UTF8Converter::actLangDecoded(path));
  }
  quickWidget->engine()->setImportPathList(paths);
}

//--------------------------------------------------------------------------------

QWidget *QtQuickWidget::widget() const
{
  return quickWidget;
}

//--------------------------------------------------------------------------------

QStringList QtQuickWidget::signalList() const
{
  QStringList list;

  list.append(QLatin1String("genericSignal(string name, dyn_anytype values)"));

  return list;
}

//--------------------------------------------------------------------------------

QStringList QtQuickWidget::methodList() const
{
  QStringList list;

  //list.append(QLatin1String("void load(string url)"));
  list.append(QLatin1String("void debug()"));

  return list;
}

//--------------------------------------------------------------------------------

QVariant QtQuickWidget::invokeMethod(const QString &name, QList<QVariant> &values, QString &error)
{
  if ( name == QLatin1String("debug") )
  {
    QStringList list;
    QObject *rootObject = quickWidget->rootObject();

    for (int i = 0; rootObject && (i < rootObject->metaObject()->methodCount()); i++)
    {
      QMetaMethod method = rootObject->metaObject()->method(i);
      if ( method.methodType() != QMetaMethod::Signal )
        continue;

      list.append(QLatin1String(method.methodSignature()));
    }
    qDebug() << "signalList" << list;
    return QVariant();
  }

  /*
  if ( name == QLatin1String("load") )
  {
    if ( !hasNumArgs(name, values, 1, error) ) return QVariant();

    quickWidget->setSource(values[0].toUrl());

    // this method returns void
    return QVariant();
  }
  */

  return BaseExternWidget::invokeMethod(name, values, error);
}

//--------------------------------------------------------------------------------

void QtQuickWidget::statusChanged(QQuickWidget::Status status)
{
  if ( status == QQuickWidget::Error )
  {
    foreach (const QQmlError &error, quickWidget->errors())
    {
      std::cerr << qPrintable(error.toString()) << std::endl;
    }
  }
  else if ( status == QQuickWidget::Ready )
  {
    // check if signal is available
    QObject *rootObject = quickWidget->rootObject();
    if ( rootObject &&
         (rootObject->metaObject()->indexOfSignal(
             QMetaObject::normalizedSignature("genericSignal(const QString &, const QJSValue &)")) != -1) )
    {
      connect(quickWidget->rootObject(), SIGNAL(genericSignal(const QString &, const QJSValue &)),
              this, SLOT(genericSlot(const QString &, const QJSValue &)));
    }
  }
}

//--------------------------------------------------------------------------------

void QtQuickWidget::sceneGraphError(QQuickWindow::SceneGraphError error, const QString &message)
{
  std::cerr << qPrintable(message) << std::endl;
}

//--------------------------------------------------------------------------------

void QtQuickWidget::genericSlot(const QString &name, const QJSValue &value)
{
  QList<QVariant> list;
  list.append(name);
  list.append(value.toVariant());

  emit signal(QLatin1String("genericSignal"), list);
}

//--------------------------------------------------------------------------------
