#ifndef _QmlDp_H_
#define _QmlDp_H_

#include <QObject>
#include <QQmlParserStatus>
#include <QVariant>

#include <DpIdentifier.hxx>
#include <Variable.hxx>

class QmlDp : public QObject, public QQmlParserStatus
{
  Q_OBJECT
  Q_INTERFACES(QQmlParserStatus)
  Q_PROPERTY(QString dpa MEMBER dpa)
  Q_PROPERTY(QVariant value READ getValue WRITE setValue NOTIFY valueChanged)

  public:
    QmlDp(QObject *parent = 0);
    virtual ~QmlDp();

    virtual void classBegin() { }
    virtual void componentComplete();

    const QVariant &getValue() const { return value; }
    void setValue(const QVariant &newValue);

    void emitNewValue(const QVariant &newValue);

    static Variable *QVariantToVariable(const QVariant &var);
    static QVariant VariableToQVariant(const Variable *var);

  signals:
    void valueChanged(const QVariant &value);

  private:
    QString dpa;
    DpIdentifier dpId;
    VariableType varType;
    QVariant value;

    class QmlHL *hl;
};

//--------------------------------------------------------------------------------
#include <HotLinkWaitForAnswer.hxx>

class QmlHL : public HotLinkWaitForAnswer
{
  public:
    QmlHL(QmlDp *theQmlDp) : qmlDp(theQmlDp) { }

    virtual void hotLinkCallBack(DpMsgAnswer &answer);
    virtual void hotLinkCallBack(DpHLGroup &group);

  private:
    QmlDp *qmlDp;
};

#endif
