﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Net;
using Roc.WCCOA;

using System.Runtime.Remoting;
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Tcp;

namespace WindowsFormsApplication1 {

    public partial class Form1 : Form
    {
        static WCCOABase server;
        static WCCOAClient client;

        TagTextBox t1;
        TagTextBox t2;

        WCCOATagList list1 = new WCCOATagList(server);
        WCCOATagList list2 = new WCCOATagList(server);
        WCCOATagList qc_list = new WCCOATagList(server);

        public class TagTextBox : WCCOATag
        {
            TextBox textbox;

            public TagTextBox(WCCOABase Conn, string DpName, TextBox textbox)
                : base(Conn, DpName)
            {
                this.textbox = textbox;
            }

            public void ShowValue()
            {
                textbox.Text = this.Value.Value.ToString();
            }

            public void ShowValue(WCCOATag Tag)
            {
                textbox.Text = Tag.Value.Value.ToString();
            }
        }

        public Form1()
        {
            InitializeComponent();

            int CtrlPort = 8080;  // oa ctrl xmlrpc

            int ProxyClientPort = 8091;  // proxy tcp port for clients
            int ProxyRemotePort = 8092; // .net remoting

            // .net remoting to proxy
            TcpChannel chan = new TcpChannel();
            ChannelServices.RegisterChannel(chan, false);

            // create remote procxy object
            WCCOAProxyRemote proxy = (WCCOAProxyRemote)Activator.GetObject(
                typeof(WCCOAProxyRemote), "tcp://" + Program.ProxyHost + ":" + ProxyRemotePort + "/WCCOAProxyRemote");

            // create server and client objects
            server = new WCCOABase(Program.CtrlHost, CtrlPort, "RPC2", Program.CtrlConn);
            client = new WCCOAClient(proxy, Program.ProxyHost, server, ProxyClientPort);

            // start and connect
            client.Start();
            client.Connect();
            Thread.Sleep(1000); // wait until client id is registered

            // tag textboxes
            t1 = new TagTextBox(server, "System1:ExampleDP_Arg1.", textBox1);
            t2 = new TagTextBox(server, "System1:ExampleDP_Arg2.", textBox2);

            // tag connect callbacks 
            t1.AddDataChangedAction(TagAction);
            t2.AddDataChangedAction(TagAction);

            // tag connect lists
            list1.Add(t1);
            list2.Add(t2);

            // query connect callback
            qc_list.AddDataChangedAction((l, f) =>
            {
                //Console.WriteLine ("QC-ListCB: " + l.TagList.Count); 
                this.BeginInvoke(new Action(() =>
                {
                    lock ( l.TagListChanged )
                    if (l.TagListChanged.Count > 0)
                    {
                        //Console.WriteLine(l.TagListChanged[0].ToString());
                        textBox3.Text = l.TagListChanged[0].ToString();
                    }
                }));
            });
        }

        //--------------------------------------------------------------------------------------------------------------------
        public void TagAction(WCCOATag Tag, bool FirstUpdate)
        {
             //Console.WriteLine("TagAction => " + FirstUpdate + " " + Tag.ToString());
             this.BeginInvoke(new Action(() => { ((TagTextBox)Tag).ShowValue(); }));
        }

        //--------------------------------------------------------------------------------------------------------------------
        private void button1Click(object sender, EventArgs e)
        {
            // set value of textbox to first datapoint
            server.setDouble(t1.DpName, Convert.ToDouble(textBox1.Text));
        }

        //--------------------------------------------------------------------------------------------------------------------
        private void button2_Click(object sender, EventArgs e)
        {
            // set value of textbox to first datapoint
            server.setDouble(t2.DpName, Convert.ToDouble(textBox2.Text));
        }

        //--------------------------------------------------------------------------------------------------------------------
        private void WaitForValue()
        {
            WCCOATagList list = new WCCOATagList(server);

            list.Add(t1);
            list.Add(t2);

            // fetch values from WinCC OA
            list.FetchValues();

            foreach (TagTextBox tag in list.FetchList)
                tag.ShowValue();

            // add a callback function (delegate)
            list.AddDataChangedAction(TagListAction);

            // start a thread and wait endless for change of values  
            Task t = Task.Factory.StartNew(() =>
            {
                while (true) list.WaitForValues(); // timeout/wait is set to 5 seconds
            });
        }

        //--------------------------------------------------------------------------------------------------------------------
        public void TagListAction(WCCOATagList TagList, bool FirstUpdate)
        {
            //Console.WriteLine("TagListAction => " + FirstUpdate + " " + TagList.TagListChanged.Count);

            // for each changed datapoint value
            foreach (TagTextBox tag in TagList.TagListChanged)
                this.BeginInvoke(new Action(() => { tag.ShowValue(); }));
        }

        //--------------------------------------------------------------------------------------------------------------------
        private void btnConnect_Click(object sender, EventArgs e)
        {
            btnConnect.Enabled = false;
            btnDisconnect.Enabled = true;

            int ret;

            // query connect single to tag
            ret = client.TagQueryConnectSingle(qc_list, "FROM 'Example*.**'", false);
            Console.WriteLine("TagQueryConnectSingle " + ret);

            // connect
            ret = client.TagConnect(list1, false);
            Console.WriteLine("TagConnect-1 " + ret);

            ret = client.TagConnect(list2, false);
            Console.WriteLine("TagConnect-2 " + ret);
        }

        private void btnDisconnect_Click(object sender, EventArgs e)
        {
            btnConnect.Enabled = true;
            btnDisconnect.Enabled = false;

            client.TagQueryDisconnect(qc_list, "FROM 'Example*.**'");
            client.TagDisconnect(list1);
            client.TagDisconnect(list2);
        }

    }



}
