using System;
using System.Net;
using System.Threading;
using System.Threading.Tasks;
using System.Collections;
using System.Collections.Generic;
using Roc.WCCOA;

using System.Runtime.Remoting;
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Tcp;

namespace WCCOANetServer
{
	class MainClass
	{		
		public static void Main (string[] args)
		{
			NetworkCredential CtrlConn = new NetworkCredential ("root", "");

			string CtrlHost = "127.0.0.1";
			string ProxyHost = "127.0.0.1";

			if (args.Length == 4) {
				CtrlHost = args[0];
				ProxyHost = args[1];
				CtrlConn = new NetworkCredential(args[2], args[3]);
			}

			int CtrlPort = 8080;  // oa ctrl xmlrpc

			int ProxyServerPort = 8090;  // proxy tcp port for server
			int ProxyClientPort = 8091;  // proxy tcp port for clients
			int ProxyRemotePort = 8092; // .net remoting

			// .net remoting for remote proxy
			IChannel channel = new TcpChannel (ProxyRemotePort);
			ChannelServices.RegisterChannel (channel, false);			
			RemotingConfiguration.RegisterWellKnownServiceType (typeof(WCCOAProxyRemote), "WCCOAProxyRemote", WellKnownObjectMode.Singleton);

			// create proxy server
			WCCOAProxyServer.proxy = new WCCOAProxy (
				new WCCOABase (CtrlHost, CtrlPort, "RPC2", CtrlConn), 
				ProxyServerPort, ProxyClientPort, ProxyHost );

			// start proxy server
			WCCOAProxyServer.proxy.Start ();
			WCCOAProxyServer.proxy.Connect ();
		}	
	}
}
