using System;
using System.Net;
using System.Threading;
using System.Threading.Tasks;
using System.Collections;
using System.Collections.Generic;
using Roc.WCCOA;

using System.Runtime.Remoting;
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Tcp;


namespace WCCOANetClient
{
	class MainClass
	{
		static WCCOABase server;
		static WCCOAClient client;
		
		public static void Main (string[] args)
		{
			NetworkCredential CtrlConn = new NetworkCredential ("root", "");

			string CtrlHost = "localhost";
			string ProxyHost = "localhost";
			
			int CtrlPort = 8080;  // oa ctrl xmlrpc
			
			int ProxyClientPort = 8091;  // proxy tcp port for clients
			int ProxyRemotePort = 8092; // .net remoting

			// .net remoting to proxy
			TcpChannel chan = new TcpChannel ();
			ChannelServices.RegisterChannel (chan, false);
			
			// create remote proxy object
			WCCOAProxyRemote proxy = (WCCOAProxyRemote)Activator.GetObject (
				typeof(WCCOAProxyRemote), "tcp://" + ProxyHost + ":" + ProxyRemotePort + "/WCCOAProxyRemote");

			// create server and client objects
			server = new WCCOABase (CtrlHost, CtrlPort, "RPC2", CtrlConn);
			client = new WCCOAClient (proxy, ProxyHost, server, ProxyClientPort);

			// start and connect
			client.Start ();		
			client.Connect ();
			Thread.Sleep (1000); // wait until client id is registered

			//Console.ReadKey();

			if (args.Length > 0) {
				Console.WriteLine (DateTime.Now + " ... " + args [0]);
				if (args [0] == "t")
					TagConnect ();
				else if (args [0] == "q")
					QueryConnect ();
			} else {
				TagConnect ();
				QueryConnect ();
			}


		}

		public static void TagConnect()
		{
			// create a tag 
			WCCOATagList list = new WCCOATagList(server);
			
			// add tag to the  list
			var t1 = new WCCOATag(server, "System1:ExampleDP_Trend1.");
			var t2 = new WCCOATag(server, "System1:ExampleDP_Arg1.");
			list.Add(t1);
			list.Add(t2);
			
			// callbacks
			list.AddDataChangedAction((l, f) => {
				Console.WriteLine ("TC-ListCB: " + l.TagList.Count);
				for ( int i=0; i<l.TagList.Count; i++ )
					Console.WriteLine ("TC-ListCB: " + l.TagList[i].ToString());
			});

			/*
			t1.AddDataChangedAction((t, f) => { 
				Console.WriteLine ("TC-TagCB1: " + t.DpName + " => " + t.Value.Value.ToString()); 
			});
			
			t2.AddDataChangedAction((t, f) => { 
				Console.WriteLine ("TC-TagCB2: " + t.DpName + " => " + t.Value.Value.ToString()); 
			});
			*/
			
			// connect
			int ret = client.TagConnect(list, false);
			Console.WriteLine("TagConnect " + ret);		
		}
		
		public static void QueryConnect()
		{
			string query="FROM '*.**'";
			
			WCCOATagList list = new WCCOATagList(server);
			var t1 = new WCCOATag(server, "System1:ExampleDP_Trend1.");
			list.Add(t1);
			
			t1.AddDataChangedAction((t, f) => { 
				Console.WriteLine ("QC-TagCB: " + t.DpName + " => " + t.Value.Value.ToString()); 
			});
			
			list.AddDataChangedAction((l, f) => { 
				//Console.WriteLine ("QC-ListCB: " + l.TagList.Count); 
			});
			
			// query connect single to tag
			int ret = client.TagQueryConnectSingle(list, query, false);
			Console.WriteLine("TagQueryConnectSingle " + ret);		
		}
	}
}
