/*
 * Decompiled with CFR 0.152.
 */
package com.etm.utils;

import java.util.logging.Level;
import java.util.logging.Logger;

public class SemaphoreDigital {
    private boolean signal;

    public SemaphoreDigital(boolean signal) {
        this.signal = signal;
    }

    public SemaphoreDigital() {
        this.signal = false;
    }

    public synchronized void request() {
        while (!this.signal) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(SemaphoreDigital.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.signal = false;
    }

    public synchronized void dispatch() {
        this.signal = true;
        this.notify();
    }

    public synchronized boolean request(int timeout) {
        if (timeout <= 0) {
            this.request();
            return false;
        }
        boolean timedout = false;
        while (!this.signal && !timedout) {
            try {
                this.wait(timeout);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(SemaphoreDigital.class.getName()).log(Level.SEVERE, null, ex);
            }
            timedout = !this.signal;
        }
        this.signal = false;
        return timedout;
    }

    public synchronized boolean read() {
        return this.signal;
    }

    public synchronized void sendTrue() {
        this.signal = true;
        this.notifyAll();
    }

    public synchronized void sendFalse() {
        this.signal = false;
        this.notifyAll();
    }

    public synchronized void awaitFalse() {
        while (this.signal) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(SemaphoreDigital.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public synchronized void awaitTrue() {
        while (!this.signal) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(SemaphoreDigital.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

