/*
 * Decompiled with CFR 0.152.
 */
package com.etm.utils;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HttpUtil {
    public static void parseQuery(String query, Map<String, Object> parameters) throws UnsupportedEncodingException {
        if (query != null) {
            String[] pairs;
            for (String pair : pairs = query.split("[&]")) {
                String[] param = pair.split("[=]");
                String key = null;
                String value = null;
                if (param.length > 0) {
                    key = URLDecoder.decode(param[0], "utf-8");
                }
                if (param.length > 1) {
                    value = URLDecoder.decode(param[1], "utf-8");
                }
                if (parameters.containsKey(key)) {
                    ArrayList<String> values;
                    Object obj = parameters.get(key);
                    if (obj instanceof List) {
                        values = (ArrayList<String>)obj;
                        values.add(value);
                        continue;
                    }
                    if (!(obj instanceof String)) continue;
                    values = new ArrayList<String>();
                    values.add((String)obj);
                    values.add(value);
                    parameters.put(key, values);
                    continue;
                }
                parameters.put(key, value);
            }
        }
    }

    public static int httpGet(String url, StringBuffer response) throws IOException {
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("GET");
        int responseCode = con.getResponseCode();
        if (response != null && responseCode == 200) {
            try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                String inputLine;
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
            }
        }
        con.disconnect();
        return responseCode;
    }

    public static int httpPost(String url, StringBuffer data) throws IOException {
        return HttpUtil.httpPost(url, data, null);
    }

    public static int httpPost(String url, StringBuffer data, StringBuffer response) throws IOException {
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("POST");
        con.setDoOutput(true);
        try (DataOutputStream wr = new DataOutputStream(con.getOutputStream());){
            wr.writeBytes(data.toString());
            wr.flush();
        }
        int responseCode = con.getResponseCode();
        if (response != null && responseCode == 200) {
            try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                String inputLine;
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
            }
        }
        con.disconnect();
        return responseCode;
    }
}

