/*
 * Decompiled with CFR 0.152.
 */
package com.etm.utils;

import com.etm.utils.LogFormatter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Debug {
    public static final Logger out = Logger.getLogger(Debug.class.getName());
    public static final String fmtDate = "yyyy.MM.dd HH:mm:ss.SSS";
    private static String path = "";

    public static void setPath(String path) {
        Debug.path = path + "/";
    }

    public static void init(String filename) throws IOException {
        FileHandler fileHandler = new FileHandler(path + filename + ".%g.log", 0x500000, 5, true);
        fileHandler.setFormatter(new LogFormatter());
        out.addHandler(fileHandler);
        out.setUseParentHandlers(false);
        File file = new File(path + filename + ".err");
        FileOutputStream fos = new FileOutputStream(file);
        PrintStream ps = new PrintStream(fos);
        System.setErr(ps);
        System.setOut(ps);
    }

    public static void StackTrace(Level level, Exception ex) {
        String trace = ex.toString() + ":\n";
        for (StackTraceElement ste : ex.getStackTrace()) {
            trace = trace + "  " + ste.getClassName() + "." + ste.getMethodName() + ":" + ste.getLineNumber() + "\n";
        }
        out.log(level, trace);
    }

    public static void StackTrace(Level level, String msg) {
        String trace = msg + ":\n";
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            trace = trace + "  " + ste.getClassName() + "." + ste.getMethodName() + ":" + ste.getLineNumber() + "\n";
        }
        out.log(level, trace);
    }
}

