/*
 * Decompiled with CFR 0.152.
 */
package com.etm.api.var;

import com.etm.api.base.JDpId;
import com.etm.api.var.Bit32Var;
import com.etm.api.var.BitVar;
import com.etm.api.var.CharVar;
import com.etm.api.var.DpIdentifierVar;
import com.etm.api.var.DynVar;
import com.etm.api.var.FloatVar;
import com.etm.api.var.IntegerVar;
import com.etm.api.var.LangTextVar;
import com.etm.api.var.TextVar;
import com.etm.api.var.TimeVar;
import com.etm.api.var.UIntegerVar;
import com.etm.api.var.VariableType;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;

public abstract class Variable
implements Serializable {
    public abstract String formatValue();

    public abstract VariableType isA();

    public abstract Object getValueObject();

    public String toString() {
        return this.formatValue();
    }

    public String getValueClassName() {
        return this.getValueObject().getClass().getSimpleName();
    }

    public int getVariableTypeAsNr() {
        return this.isA().value;
    }

    public static Variable newVariable(Object value) {
        if (value instanceof String) {
            return new TextVar((String)value);
        }
        if (value instanceof Double) {
            return new FloatVar((Double)value);
        }
        if (value instanceof BigDecimal) {
            return new FloatVar(((BigDecimal)value).doubleValue());
        }
        if (value instanceof Float) {
            return new FloatVar(((Float)value).doubleValue());
        }
        if (value instanceof Integer) {
            return new IntegerVar((Integer)value);
        }
        if (value instanceof Boolean) {
            return new BitVar((Boolean)value);
        }
        if (value instanceof Character) {
            return new CharVar((Character)value);
        }
        if (value instanceof Timestamp) {
            return new TimeVar(((Timestamp)value).getTime());
        }
        throw new UnsupportedOperationException("Type " + value.getClass().getName() + " [" + value.toString() + "] not supported yet.");
    }

    public Bit32Var getBit32Var() {
        return (Bit32Var)this;
    }

    public BitVar getBitVar() {
        return (BitVar)this;
    }

    public CharVar getCharVar() {
        return (CharVar)this;
    }

    public DpIdentifierVar getDpIdentifierVar() {
        return (DpIdentifierVar)this;
    }

    public DynVar getDynVar() {
        return (DynVar)this;
    }

    public FloatVar getFloatVar() {
        return (FloatVar)this;
    }

    public IntegerVar getIntegerVar() {
        return (IntegerVar)this;
    }

    public LangTextVar getLangTextVar() {
        return (LangTextVar)this;
    }

    public TextVar getTextVar() {
        return (TextVar)this;
    }

    public TimeVar getTimeVar() {
        return (TimeVar)this;
    }

    public UIntegerVar getUIntegerVar() {
        return (UIntegerVar)this;
    }

    public static Variable newBit32Var(long value) {
        return new Bit32Var(value);
    }

    public static Variable newBitVar(boolean value) {
        return new BitVar(value);
    }

    public static Variable newBitVar(int value) {
        return new BitVar(value);
    }

    public static Variable newCharVar(char value) {
        return new CharVar(value);
    }

    public static Variable newDpIdentifierVar(JDpId value) {
        return new DpIdentifierVar(value);
    }

    public static Variable newDynVar() {
        return new DynVar();
    }

    public static Variable newFloatVar(double value) {
        return new FloatVar(value);
    }

    public static Variable newFloatVar(float value) {
        return new FloatVar(value);
    }

    public static Variable newIntegerVar(int value) {
        return new IntegerVar(value);
    }

    public static Variable newIntegerVar(long value) {
        return new IntegerVar(value);
    }

    public static Variable newLangTextVar() {
        return new LangTextVar();
    }

    public static Variable newTextVar(String value) {
        return new TextVar(value);
    }

    public static Variable newTimeVar(long value) {
        return new TimeVar(value);
    }

    public static Variable newTimeVar(Date value) {
        return new TimeVar(value);
    }

    public static Variable newUIntegerVar(int value) {
        return new UIntegerVar(value);
    }
}

