/*
 * Decompiled with CFR 0.152.
 */
package com.etm.api.var;

import com.etm.api.var.Variable;
import com.etm.api.var.VariableType;
import java.util.Date;
import java.util.TimeZone;

public class TimeVar
extends Variable {
    private static TimeZone tz = TimeZone.getDefault();
    private Date value;

    public TimeVar() {
        this.value = new Date();
    }

    public TimeVar(Date value) {
        this.value = value;
    }

    public TimeVar(long ms) {
        this.value = new Date(ms);
    }

    public void setValue(Date value) {
        this.value = value;
    }

    public void setValue(long ms) {
        this.value = new Date(ms);
    }

    public Date getValue() {
        return this.value;
    }

    public long getTime() {
        return this.value.getTime();
    }

    @Override
    public String formatValue() {
        return this.value.toString();
    }

    @Override
    public VariableType isA() {
        return VariableType.TimeVar;
    }

    @Override
    public Object getValueObject() {
        return this.value;
    }

    public TimeVar getLocalTime() {
        return new TimeVar(new Date(this.getTime() + (long)tz.getRawOffset() + (long)(tz.inDaylightTime(this.value) ? tz.getDSTSavings() : 0)));
    }

    public TimeVar getUTCTime() {
        return new TimeVar(new Date(this.getTime() - (long)tz.getRawOffset() - (long)(tz.inDaylightTime(this.value) ? tz.getDSTSavings() : 0)));
    }
}

