/*
 * Decompiled with CFR 0.152.
 */
package com.etm.api.base;

import com.etm.api.base.JDpId;
import com.etm.api.base.JDpVCItem;
import com.etm.api.base.JHotLinkWaitForAnswer;
import com.etm.api.jni.Manager;
import com.etm.api.var.Variable;
import com.etm.utils.Debug;
import com.etm.utils.SemaphoreDigital;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;

public class JManager
extends Manager
implements Runnable {
    public static final int DB_MAN = 3;
    public static final int API_MAN = 7;
    public static final int MAX_ENQUEUE_SIZE = 1000;
    private static JManager instance = null;
    protected SemaphoreDigital loopPaused = new SemaphoreDigital(true);
    protected volatile boolean apiEnabled = false;
    protected volatile boolean loopBreak = false;
    private final ConcurrentHashMap<Integer, JHotLinkWaitForAnswer> hotlinkList = new ConcurrentHashMap();
    private final ConcurrentLinkedQueue<JHotLinkWaitForAnswer> hotlinkQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Callable> taskQueue = new ConcurrentLinkedQueue();
    private final int loopWaitUSec = 1000;
    private String projName = "<unknown>";
    private String projDir = ".";
    private String confDir = ".";
    private int manType = 7;
    private int manNum = 1;

    public static JManager getInstance() {
        return instance;
    }

    public String getProjDir() {
        return this.projDir;
    }

    public JManager setProjDir(String projDir) {
        this.projDir = projDir;
        Debug.setPath(this.projDir + "/log");
        this.confDir = this.projDir + "/config";
        return this;
    }

    public JManager setProjName(String projName) {
        this.projName = projName;
        return this;
    }

    public String getConfigDir() {
        return this.confDir;
    }

    public boolean apiEnabled() {
        return this.apiEnabled;
    }

    public int getManType() {
        return this.manType;
    }

    public JManager setManType(int manType) {
        this.manType = manType;
        return this;
    }

    public int getManNum() {
        return this.manNum;
    }

    public JManager setManNum(int manNum) {
        this.manNum = manNum;
        return this;
    }

    public JManager init(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-projDir") && args.length > i + 1) {
                this.setProjDir(args[i + 1]);
            }
            if (args[i].equals("-proj") && args.length > i + 1) {
                this.setProjName(args[i + 1]);
            }
            if (args[i].equals("-num") && args.length > i + 1) {
                this.setManNum(Integer.valueOf(args[i + 1]));
            }
            if (!args[i].equals("-db")) continue;
            this.setManType(3);
        }
        return this.init();
    }

    public JManager init(String projName, int manType, int manNum) throws Exception {
        this.setProjName(projName);
        this.setManType(manType);
        this.setManNum(manNum);
        return this.init();
    }

    public JManager init() throws Exception {
        if (instance != null) {
            throw new Exception("There can only be one manager!");
        }
        instance = this;
        this.apiEnabled = false;
        String errmsg = "";
        try {
            System.loadLibrary("WCCOAjava");
            this.apiEnabled = true;
        }
        catch (UnsatisfiedLinkError ex) {
            errmsg = ex.getMessage();
        }
        try {
            Debug.init("WCCOAjava" + this.manNum);
        }
        catch (IOException ex) {
            Debug.StackTrace(Level.SEVERE, ex);
        }
        if (!this.apiEnabled) {
            Debug.out.severe(errmsg);
        }
        return this;
    }

    public void start() {
        if (this.apiEnabled) {
            this.apiStartup(this.manType, new String[]{"WCCOAjava", "-proj", this.projName, "-num", Integer.toString(this.manNum)});
            this.loopPaused.sendFalse();
            new Thread(this).start();
        }
    }

    public void stop() {
        if (this.apiEnabled) {
            Debug.out.log(Level.INFO, "api manager stop...");
            this.apiEnabled = false;
            this.pause();
            Debug.out.log(Level.INFO, "api manager shutdown...");
            this.apiShutdown();
            Debug.out.log(Level.INFO, "api manager stopped.");
        }
    }

    @Override
    public void run() {
        while (this.apiEnabled) {
            Debug.out.log(Level.INFO, "api manager loop waiting.");
            this.loopPaused.awaitFalse();
            Debug.out.log(Level.INFO, "api manager loop started.");
            while (!this.loopBreak) {
                this.apiDispatch(0, 1000);
                this.queueWorker();
            }
            this.loopPaused.sendTrue();
            Debug.out.log(Level.INFO, "api manager loop stopped.");
        }
        this.apiEnabled = false;
    }

    public void pause() {
        this.loopBreak = true;
        this.loopPaused.awaitTrue();
    }

    public void resume() {
        this.loopBreak = false;
        this.loopPaused.sendFalse();
    }

    protected void enqueue(JHotLinkWaitForAnswer hl) {
        if (this.hotlinkQueue.size() >= 1000) {
            Debug.out.log(Level.WARNING, "pending list {0} delay processing...", this.hotlinkQueue.size());
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                Debug.StackTrace(Level.SEVERE, ex);
            }
        } else {
            this.hotlinkQueue.add(hl);
        }
    }

    protected void register(JHotLinkWaitForAnswer hl) {
        this.hotlinkList.put(hl.getHdlId(), hl);
    }

    protected void deregister(JHotLinkWaitForAnswer hl) {
        this.hotlinkList.remove(hl.getHdlId());
    }

    private void queueWorker() {
        JHotLinkWaitForAnswer hotlink;
        for (int k = 0; k <= 100 && (hotlink = this.hotlinkQueue.poll()) != null; ++k) {
            hotlink.call();
        }
        Callable task = this.taskQueue.poll();
        if (task != null) {
            try {
                task.call();
            }
            catch (Exception ex) {
                Debug.StackTrace(Level.SEVERE, ex);
            }
        }
    }

    public boolean addTask(Callable task) {
        return this.taskQueue.add(task);
    }

    @Override
    public int callbackAnswer(int id, int idx, JDpId dpid, Variable var) {
        JHotLinkWaitForAnswer hdl = this.hotlinkList.get(id);
        if (hdl != null) {
            switch (idx) {
                case -1: {
                    hdl.answerInit();
                    break;
                }
                case -2: {
                    hdl.callbackDone();
                    break;
                }
                default: {
                    hdl.callbackItem(new JDpVCItem(dpid, var));
                }
            }
            return 0;
        }
        return -1;
    }

    @Override
    public int callbackHotlink(int id, int idx, JDpId dpid, Variable var) {
        JHotLinkWaitForAnswer hdl = this.hotlinkList.get(id);
        if (hdl != null) {
            switch (idx) {
                case -1: {
                    hdl.hotlinkInit();
                    break;
                }
                case -2: {
                    hdl.callbackDone();
                    break;
                }
                default: {
                    hdl.callbackItem(new JDpVCItem(dpid, var));
                }
            }
            return 0;
        }
        return -1;
    }

    @Override
    public boolean doReceiveSysMsg(long cPtrSysMsg) {
        return false;
    }

    @Override
    public boolean doReceiveDpMsg(long cPtrDpMsg) {
        return false;
    }

    @Override
    public int callbackHotlinkGroup(int id, long ptrDpHlGroup) {
        this.apiProcessHotlinkGroup(id, ptrDpHlGroup);
        return 0;
    }
}

