/*
 * Decompiled with CFR 0.152.
 */
package com.etm.api.base;

import com.etm.api.base.IAnswer;
import com.etm.api.base.IHotLink;
import com.etm.api.base.JDpHLGroup;
import com.etm.api.base.JDpMsgAnswer;
import com.etm.api.base.JDpVCGroup;
import com.etm.api.base.JDpVCItem;
import com.etm.api.base.JManager;
import com.etm.utils.Debug;
import com.etm.utils.SemaphoreAnalog;
import com.etm.utils.SemaphoreDigital;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Level;

public abstract class JHotLinkWaitForAnswer
implements Runnable {
    protected long cptr = 0L;
    protected long cid = 0L;
    private int retCode;
    private int hdlId = 0;
    private static volatile int hdlSequence = 0;
    private JDpVCGroup message;
    private JDpMsgAnswer answer;
    protected IAnswer cbAnswer;
    protected IHotLink cbHotlink;
    protected final SemaphoreDigital gotAnswer = new SemaphoreDigital(false);
    private boolean async = false;
    private volatile boolean running;
    private Queue<JDpVCGroup> msgQueue;
    private SemaphoreAnalog msgWait;
    private final int MAX_QUEUE_SIZE = 1000;

    protected void setAsync() {
        this.setAsync(true);
    }

    protected void setAsync(boolean async) {
        if (async && !this.async) {
            if (this.msgQueue == null) {
                this.msgQueue = new LinkedList<JDpVCGroup>();
            }
            if (this.msgWait == null) {
                this.msgWait = new SemaphoreAnalog();
            }
            this.running = true;
            new Thread(this).start();
        }
        if (!async && this.async) {
            this.running = false;
        }
        this.async = async;
    }

    protected void setCPtr(long cptr) {
        this.cptr = cptr;
    }

    protected long getCPtr() {
        return this.cptr;
    }

    protected void setCId(long cid) {
        this.cid = cid;
    }

    protected long getCId() {
        return this.cid;
    }

    protected int getHdlId() {
        if (this.hdlId > 0) {
            return this.hdlId;
        }
        this.hdlId = ++hdlSequence;
        return hdlSequence;
    }

    public int getRetCode() {
        return this.retCode;
    }

    protected abstract int execute();

    protected JHotLinkWaitForAnswer action(IAnswer answer) {
        this.setAsync();
        this.cbAnswer = answer;
        return this;
    }

    protected JHotLinkWaitForAnswer action(IHotLink hotlink) {
        this.setAsync();
        this.cbHotlink = hotlink;
        return this;
    }

    protected void hotlink(JDpHLGroup group) {
        if (this.cbHotlink != null) {
            this.cbHotlink.hotlink(group);
        }
    }

    protected void answer(JDpMsgAnswer answer) {
        if (this.cbAnswer != null) {
            this.cbAnswer.answer(answer);
        }
    }

    protected int call() {
        this.retCode = this.execute();
        if (this.retCode != 0) {
            this.answer = new JDpMsgAnswer();
            this.answer.setRetCode(this.retCode);
            this.gotAnswer.sendTrue();
        }
        return this.retCode;
    }

    protected void register() {
        JManager.getInstance().register(this);
    }

    protected void deregister() {
        JManager.getInstance().deregister(this);
        if (this.async) {
            this.running = false;
            this.msgWait.addOne();
        }
    }

    public void waitForAnswer() {
        this.gotAnswer.awaitTrue();
    }

    protected JDpVCGroup getMessage() {
        return this.message;
    }

    protected void setMessage(JDpVCGroup message) {
        this.message = message;
    }

    protected void setAnswer(JDpMsgAnswer answer) {
        this.answer = answer;
        this.answer.setRetCode(this.getRetCode());
    }

    public JDpMsgAnswer getAnswer() {
        return this.answer;
    }

    protected synchronized void answerInit() {
        this.message = new JDpMsgAnswer();
    }

    protected synchronized void hotlinkInit() {
        this.message = new JDpHLGroup();
    }

    protected synchronized void callbackItem(JDpVCItem item) {
        this.message.addItem(item);
    }

    protected synchronized void callbackDone() {
        if (this.async) {
            this.callbackDoneAsync();
        } else {
            this.callbackDoneSync();
        }
    }

    private void callbackDoneSync() {
        if (this.message != null) {
            if (this.message instanceof JDpMsgAnswer) {
                this.setAnswer((JDpMsgAnswer)this.message);
                this.answer(this.getAnswer());
                this.gotAnswer.sendTrue();
            } else if (this.message instanceof JDpHLGroup) {
                this.hotlink((JDpHLGroup)this.message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callbackDoneAsync() {
        SemaphoreAnalog semaphoreAnalog = this.msgWait;
        synchronized (semaphoreAnalog) {
            if (this.msgQueue.size() > 1000) {
                Debug.out.log(Level.WARNING, "callback queue size {0} {1}", new Object[]{this.msgQueue.size(), this.msgWait.getValue()});
            } else {
                this.msgQueue.add(this.getMessage());
                this.msgWait.addOne();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.running) {
            JDpVCGroup msg;
            SemaphoreAnalog semaphoreAnalog = this.msgWait;
            synchronized (semaphoreAnalog) {
                this.msgWait.getOne();
                msg = this.msgQueue.poll();
            }
            if (msg == null) continue;
            this.setMessage(msg);
            if (msg instanceof JDpMsgAnswer) {
                this.setAnswer((JDpMsgAnswer)msg);
                this.answer(this.getAnswer());
                this.gotAnswer.sendTrue();
                continue;
            }
            if (!(msg instanceof JDpHLGroup)) continue;
            try {
                this.hotlink((JDpHLGroup)msg);
            }
            catch (Exception ex) {
                Debug.StackTrace(Level.SEVERE, ex);
            }
        }
    }
}

