﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace PanelXmlToLib
{
    public partial class MainForm : Form
    {
        #region Construction
        public MainForm()
        {
            InitializeComponent();
        }
        #endregion

        #region Private methods.
        private void LoadFiles(string path)
        {
            int numFiles = 0;
            try
            {
                // Get all files with the ".xml" extention recursivly and add them
                // to the check listbox.
                DirectoryInfo di = new DirectoryInfo(path);
                FileInfo[] files = di.GetFiles("*.xml", SearchOption.AllDirectories);
                numFiles = files.Length;
                fileList.Items.Clear();
                foreach (FileInfo fi in files)
                {
                    fileList.Items.Add(fi.FullName.Replace(sourcePath.Text + "\\", ""));
                }
            }
            catch (Exception ex)
            {
                // Probably a wrong path...
                fileList.Items.Clear();
                MessageBox.Show(ex.Message, "Error...", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            finally
            {
                // Reset the progress bar.
                progress.Minimum = 0;
                progress.Maximum = numFiles;
                progress.Value = 0;
            }
        }
        #endregion

        #region Private event handlers.
        private void generate_Click(object sender, EventArgs e)
        {
            // Iterate the checked files from the list and
            // generate the source for these files.
            progress.Value = 0;
            progress.Maximum = fileList.CheckedItems.Count;
            foreach (object file in fileList.CheckedItems )
            {
                XmlToLib.LoadXmlAndConvertToLib(Path.Combine(sourcePath.Text, file.ToString()), sourcePath.Text, targetPath.Text);
                progress.Value = progress.Value + 1;
            }

            // We are done.
            MessageBox.Show("All source code has been extracted.", "Done!", MessageBoxButtons.OK, MessageBoxIcon.Information);
        }

        private void sourceSelect_Click(object sender, EventArgs e)
        {
            // Use an already selected folder as our base.
            if (String.IsNullOrEmpty(sourcePath.Text))
            {
                folderBrowserDialog.SelectedPath = targetPath.Text;
            }
            else
            {
                folderBrowserDialog.SelectedPath = sourcePath.Text;
            }

            // Open the folder dialog and load the files from the
            // selected source path.
            folderBrowserDialog.Description = "Select the folder where the source XML panels are located.";
            if (folderBrowserDialog.ShowDialog() == DialogResult.OK)
            {
                sourcePath.Text = folderBrowserDialog.SelectedPath;
                LoadFiles(sourcePath.Text);
            }
        }

        private void targetSelect_Click(object sender, EventArgs e)
        {
            // Use an already selected folder as our base.
            if (String.IsNullOrEmpty(targetPath.Text))
            {
                folderBrowserDialog.SelectedPath = sourcePath.Text;
            }
            else
            {
                folderBrowserDialog.SelectedPath = targetPath.Text;
            }

            // Open the folder dialog.
            folderBrowserDialog.Description = "Select the folder where extracted source files will be written. An empty folder means generated the files in the source folder.";
            if (folderBrowserDialog.ShowDialog() == DialogResult.OK)
            {
                targetPath.Text = folderBrowserDialog.SelectedPath;
            }
        }

        private void all_Click(object sender, EventArgs e)
        {
            // Select all files in the list.
            for (int index = 0; index < fileList.Items.Count; index++)
            {
                fileList.SetItemChecked(index, true); 
            }
        }

        private void none_Click(object sender, EventArgs e)
        {
            // Unselect all files from the list.
            for (int index = 0; index < fileList.Items.Count; index++)
            {
                fileList.SetItemChecked(index, false);
            }
        }

        private void sourcePath_Leave(object sender, EventArgs e)
        {
            // Load the files from the entered path.
            if (!String.IsNullOrEmpty(sourcePath.Text))
            {
                LoadFiles(sourcePath.Text);
            }
        }

        private void sourcePath_KeyPress(object sender, KeyPressEventArgs e)
        {
            // Load the files from the entered path.
            if (e.KeyChar == '\r')
            {
                LoadFiles(sourcePath.Text);
                e.Handled = true;
            }
        }
        #endregion
    }
}
