/*
  this library allows to add extended filters for alarm and event screen 
  
  if the panel panels/vision/aes/AS_propFilterExtended.pnl exists, it will be displayed as separate tab in AES property dialog (for alarms)
  as template for this panel, <WinCC OA installation path>/panels/vision/aes/_AS_propFilterExtended.pnl can be used
  if the panel panels/vision/aes/ES_propFilterExtended.pnl exists, it will be displayed as separate tab in AES property dialog (for events)
  as template for this panel, <WinCC OA installation path>/panels/vision/aes/_ES_propFilterExtended.pnl can be used
  
  for using the extended alarm filters, load this CTRL library via config file
  [ui]
  LoadCtrlLibs = "HOOK_aes_modifyQuery.ctl"
*/


/** 
  function for modifying AES query before executing/connecting
  @param sQuery 
  @param sPropertyDP 
*/
HOOK_aes_modifyQuery(string &sQuery, string sPropertyDP)
{
  string sExtendedFilter; // e.g. "('_alert_hdl.._prior' IN RANGE(60))";
  
  dyn_string dsExtendedFilers;
  dpGetCache(sPropertyDP+ ".Both.FilterExtended.Filters", dsExtendedFilers);

  for(int i=1; i<=dynlen(dsExtendedFilers); i++)
  {
    if(i!=1)
      sExtendedFilter+=" AND "; //adding separator
    
    sExtendedFilter+=dsExtendedFilers[i];
  }  
  
  DebugFTN("extendedFilter", "using filters:", dsExtendedFilers, sExtendedFilter);
  
  if(dynlen(dsExtendedFilers)<1) //no extended filters defined, so here is nothing to do
    return;
  
  DebugFTN("extendedFilter", "HOOK_aes_modifyQuery", sPropertyDP, sQuery);
  int iPosWhere = strpos(sQuery, "WHERE");
  DebugFTN("extendedFilter", "Where pos",iPosWhere);
  
  int iPosPart3 = strpos(sQuery, "TIMERANGE");  
  
  string sPart1, sPart2, sPart3;
  
  if(iPosPart3>0)
  {
    sPart3 = substr(sQuery, iPosPart3);
    sQuery = substr(sQuery, 0, iPosPart3);
  }    

  if(iPosWhere<0) //no where clause found
  {
    sPart1=sQuery;
  }
  else
  {
    sPart1 = substr(sQuery, 0, iPosWhere-1);
    sPart2 = substr(sQuery, iPosWhere+7);
  }
  
  if(iPosWhere<0) //no where clause found
  {
    sQuery = sPart1+" WHERE "+sExtendedFilter+sPart3;
  }
  else
    sQuery = sPart1+" WHERE "+sExtendedFilter+" AND "+sPart2+sPart3;
  
  DebugFTN("extendedFilter", "substrings",sPart1, sPart2, sPart3);
  DebugFTN("extendedFilter", "new query:", sQuery);
}

/** 
  function for reading extended filters from AES property panel and saving them to DP
  @param sPropertyDP 
*/
HOOK_aes_saveProperties(string sPropertyDP)
{
  string sExtendedFilter;
  dyn_string dsExtendedFilers;
  
  if(shapeExists("txtExtendedFilters"))
    getValue("txtExtendedFilters", "text", sExtendedFilter);
  
  dsExtendedFilers = strsplit(sExtendedFilter, "$");
  
  DebugFTN("extendedFilter", "HOOK_aes_saveProperties", sPropertyDP, dsExtendedFilers);
  dpSetCache(sPropertyDP+ ".Both.FilterExtended.Filters", dsExtendedFilers);
}

/** 
  function for reading extended filters from AES property DP and display it in the AES property panel
  @param sPropertyDP 
*/
HOOK_aes_loadProperties(string sPropertyDP)
{
  string sExtendedFilter;
  dyn_string dsExtendedFilers;
  dpGetCache(sPropertyDP+ ".Both.FilterExtended.Filters", dsExtendedFilers);
  
  DebugFTN("extendedFilter", "HOOK_aes_loadProperties", sPropertyDP, dsExtendedFilers);

  for(int i=1; i<=dynlen(dsExtendedFilers); i++)
  {
    if(i!=1)
      sExtendedFilter+="$"; //adding separator
    
    sExtendedFilter+=dsExtendedFilers[i];
  }
  
  if(shapeExists("txtExtendedFilters"))
    setValue("txtExtendedFilters", "text", sExtendedFilter);
}
