#ifndef FLOWLAYOUT_H
#define FLOWLAYOUT_H

#include <QObject>
#include <QtGui>
#include <QList>

class FlowLayout : public QLayout
{
public:
		enum VOrientation {
				TopDown = 0x1,
				BottomUp = 0x2
		};

		enum HOrientation {
				LeftToRight = 0x1,
				RightToLeft = 0x2
		};


        FlowLayout(QWidget *parent, int margin = -1, int hSpacing = -1, int vSpacing = -1);
        FlowLayout(int margin = -1, int hSpacing = -1, int vSpacing = -1);
        ~FlowLayout();

		void addItem(QLayoutItem *);
		int horizontalSpacing() const;
		int verticalSpacing() const;
		Qt::Orientations expandingDirections() const;
		bool hasHeightForWidth() const;
		int heightForWidth(int) const;
		int count() const;
		QLayoutItem *itemAt(int) const;
		QSize minimumSize() const;
        virtual void setGeometry(const QRect &);
		QSize sizeHint() const;
		QLayoutItem *takeAt(int);

private:
		int doLayout(const QRect &, bool) const;
		int smartSpacing(QStyle::PixelMetric) const;

		int getInitialX(const QRect&) const;
		int getInitialY(const QRect&) const;
		int getNextX(const QSize&, int, int) const;
		int getNextY(int, int) const;
		int getGeometryX (const QSize&, int) const;
		int getGeometryY (const QSize&, int) const;
		bool evalNewLine(const QRect&, int, int) const;

		QList<QLayoutItem *> itemList;
		int m_hSpace;
		int m_vSpace;

		FlowLayout::VOrientation vOrientation;
		FlowLayout::HOrientation hOrientation;
};


#endif // FLOWLAYOUT_H
