#ifndef FILTERWIDGET_H
#define FILTERWIDGET_H

#include <QWidget>
#include <QPainter>

#include "Filter/AbstractTree/FilterElement.h"
#include "ui_filterwidget.h"

// Moc

/*
namespace Ui {
	class FilterWidget;
}*/


class FilterWidget : public QWidget
{
	Q_OBJECT

	Q_PROPERTY( int marginHeight READ getMarginHeight WRITE setMarginHeight DESIGNABLE true )
	Q_PROPERTY( int marginWidth READ getMarginWidth WRITE setMarginWidth DESIGNABLE true )
	Q_PROPERTY(QColor equalsColor READ getEqualsColor WRITE setEqualsColor DESIGNABLE true)
	Q_PROPERTY(QColor notEqualsColor READ getNotEqualsColor WRITE setNotEqualsColor DESIGNABLE true)
	Q_PROPERTY(int alpha READ getAlpha WRITE setAlpha DESIGNABLE true)

public:
	explicit FilterWidget(const FilterElement* filter, QWidget *parent = 0);
	virtual ~FilterWidget();

	const FilterElement* filter() const;

	int getMarginHeight() const;
	void setMarginHeight(int value);
	int getMarginWidth() const;
	void setMarginWidth(int value);

	QColor getEqualsColor() const;
	void setEqualsColor(const QColor&);
	QColor getNotEqualsColor() const;
	void setNotEqualsColor(const QColor&);
	int getAlpha() const;
	void setAlpha(int);


signals:
	void closed(FilterWidget* sender);

public slots:
	void paintEvent(QPaintEvent *);

private:
    Ui::FilterWidget* ui;
	const FilterElement* _filter;
	int _textHeight;
	int _textWidth;
	int _marginHeight;
	int _marginWidth;
	QColor _equalsColor;
	QColor _notEqualsColor;
	int alpha;

private slots:
	void onCloseButtonClicked(bool);
};

#endif // FILTERWIDGET_H
