#include "FilterWidget.h"
#include "AbstractTree/Equals.h"
#include "AbstractTree/NotEquals.h"

FilterWidget::FilterWidget(const FilterElement* filter, QWidget *parent)
	: QWidget( parent ), ui(new Ui::FilterWidget), _filter(filter),
		_marginHeight(15), _marginWidth(50),
		_equalsColor(QColor(Qt::gray)), _notEqualsColor(QColor(Qt::gray)), alpha(50)
{
	const QString& name = filter->name();

	ui->setupUi(this);
	ui->nameLabel->setText(name);
	QFontMetrics metrics(ui->nameLabel->font());
	QRect boundingBox = metrics.boundingRect(ui->nameLabel->text());
	_textHeight = boundingBox.height();
	_textWidth = boundingBox.width();

	connect(ui->closeButton, SIGNAL(clicked(bool)), SLOT(onCloseButtonClicked(bool)));
}

FilterWidget::~FilterWidget()
{
}

const FilterElement *FilterWidget::filter() const
{
	return _filter;
}

int FilterWidget::getMarginHeight() const
{
	return _marginHeight;
}

void FilterWidget::setMarginHeight(int value)
{
	_marginHeight = value;
	this->setMinimumHeight(_textHeight + _marginHeight);
}

int FilterWidget::getMarginWidth() const
{
	return _marginWidth;
}

void FilterWidget::setMarginWidth(int value)
{
	_marginWidth = value;
	this->setMinimumWidth(_textWidth + _marginWidth);
}

QColor FilterWidget::getEqualsColor() const
{
	return _equalsColor;
}

void FilterWidget::setEqualsColor(const QColor &value)
{
	_equalsColor = value;
}

QColor FilterWidget::getNotEqualsColor() const
{
	return _notEqualsColor;
}

void FilterWidget::setNotEqualsColor(const QColor &value)
{
	_notEqualsColor = value;
}

int FilterWidget::getAlpha() const
{
	return alpha;
}

void FilterWidget::setAlpha(int value)
{
	alpha = value;
}

void FilterWidget::paintEvent(QPaintEvent *)
{
	QPainter p(this);
	p.setRenderHint(QPainter::Antialiasing);

	int w = size().width() - 10;
	int h = size().height() - 10;

	QColor color;

	if (_filter->inherits(Equals::staticMetaObject.className())) {
		color = _equalsColor;
	} else {
		color = _notEqualsColor;
	}

	QColor fillColor = QColor(color);
	fillColor.setAlpha(alpha);

	QPainterPath path;
	path.addRoundedRect(QRectF(0, 5, w, h), 4, 4);
	QPen pen(color, 1);
	p.setPen(pen);
	p.fillPath(path, fillColor);
	p.drawPath(path);
}

void FilterWidget::onCloseButtonClicked(bool)
{
	closed(this);
}
