#include "Equals.h"

Equals::Equals(int columnIndex, const QString &columnName, const QVariant &compare, const QString &compareText, QObject *parent) :
		Comparison(columnIndex, columnName, compare, compareText, parent)
{
}

bool Equals::eval(const Context& context) const
{
	QModelIndex index = context.getSourceModel()->index(context.getSourceRow(), _columnIndex, context.getSourceParent());
	return context.getSourceModel()->data(index) == _compare;

}

QString Equals::asQuery() const
{
		return QString("%1 = %2").arg(_columnName).arg(_compareText);

}

QString Equals::name() const
{
		return _compareText;
}

void Equals::buildXmlSettings(QDomDocument& dom, QDomElement &element) const
{
		QDomElement equals = dom.createElement("Equals");
		equals.setAttribute("columnIndex", _columnIndex);
		equals.setAttribute("columnName", _columnName);
		equals.setAttribute("compare", _compare.toString());
		equals.setAttribute("compareText", _compareText);
		element.appendChild(equals);
}
