#ifndef COMPARISON_H
#define COMPARISON_H

#include <QVariant>

#include "FilterElement.h"

class Comparison : public FilterElement
{
	Q_OBJECT
public:
	explicit Comparison(int, const QString&, const QVariant&, const QString& compareText = NULL, QObject *parent = NULL);
	virtual ~Comparison();

	virtual bool eval(const Context&) const = 0;
	virtual QString asQuery() const = 0;
	virtual QString name() const = 0;

	int columnIndex() const;
	QString columnName() const;
	QVariant compare() const;
	QString compareText() const;

protected:
	int _columnIndex;
	const QString _columnName;
	const QVariant _compare;
	QString _compareText;

signals:

public slots:
};

#endif // COMPARISON_H
