#include <QtGui>

#include "SpinboxDelegate.hxx"

SpinboxDelegate::SpinboxDelegate(int minimum, int maximum, QObject *parent)
	: QStyledItemDelegate(parent) {

	this->minimum = minimum;
	this->maximum = maximum;

}

QWidget *SpinboxDelegate::createEditor(QWidget *parent,
										 const QStyleOptionViewItem &/* option */,
										 const QModelIndex &/* index */) const
{
	QSpinBox *editor = new QSpinBox(parent);
	editor->setMinimum(this->minimum);
	editor->setMaximum(this->maximum);
	editor->installEventFilter(const_cast<SpinboxDelegate*>(this));

	connect(editor, SIGNAL(valueChanged(int)), this, SLOT(onCurrentStateChanged(int)));
	editor->installEventFilter(const_cast<SpinboxDelegate*>(this));

	return editor;
}

void SpinboxDelegate::setEditorData(QWidget *editor,
									const QModelIndex &index) const
{
	int value = index.model()->data(index, Qt::DisplayRole).toInt();

	QSpinBox *spinBox = static_cast<QSpinBox*>(editor);
	spinBox->setValue(value);
}

void SpinboxDelegate::setModelData(QWidget *editor, QAbstractItemModel *model,
									 const QModelIndex &index) const
{
	QSpinBox *spinBox = static_cast<QSpinBox*>(editor);
	spinBox->interpretText();
	int value = spinBox->value();

	model->setData(index, value);
}

void SpinboxDelegate::updateEditorGeometry(QWidget *editor,
											 const QStyleOptionViewItem &option, const QModelIndex &/* index */) const
{
	editor->setGeometry(option.rect);
}

void SpinboxDelegate::onCurrentStateChanged(int)
{
	QWidget *editor = qobject_cast<QWidget*>(sender());
	emit commitData(editor);
}
