#include "CheckboxDelegate.hxx"

#include <QApplication>
#include <QCheckBox>
#include <QPainter>
#include <QHBoxLayout>

#include <QDebug>

CheckboxDelegate::CheckboxDelegate(QObject *parent)
	: QStyledItemDelegate(parent)
{
}

void CheckboxDelegate::paint(QPainter *painter,
							 const QStyleOptionViewItem &option,
							 const QModelIndex &index) const {

	bool checkValue;

	QStyleOptionButton opt;
	QStyleOptionButton BtnStyle;

	BtnStyle.state = QStyle::State_Enabled;
	if(index.model()->data(index, Qt::DisplayRole).toBool() == true) {
		BtnStyle.state |= QStyle::State_On;
		checkValue = true;
	} else {
		BtnStyle.state |= QStyle::State_Off;
		checkValue = false;
	}

	QColor background = index.model()->data(index, Qt::BackgroundRole).value<QColor>();
	if (background.isValid()) painter->fillRect(option.rect, background);

	opt.rect = QApplication::style()->subElementRect( QStyle::SE_CheckBoxIndicator, &opt, NULL );
	const int x = option.rect.center().x() - opt.rect.width() / 2;
	const int y = option.rect.center().y() - opt.rect.height() / 2;
	opt.rect.moveTo( x, y );

	BtnStyle.direction = QApplication::layoutDirection();
	BtnStyle.rect = opt.rect;

	QApplication::style()->drawControl(QStyle::CE_CheckBox,&BtnStyle,painter );

}

QWidget *CheckboxDelegate::createEditor(QWidget *parent,
										const QStyleOptionViewItem &/* option */,
										const QModelIndex &/* index */) const
{
	QWidget *editor = new QWidget(parent);
	QCheckBox *checkBox = new QCheckBox();
	QHBoxLayout *layout = new QHBoxLayout();
	layout->addWidget(checkBox);
	layout->setAlignment(Qt::AlignCenter);
	layout->setContentsMargins(0,0,0,0);
	editor->setLayout(layout);

	connect(checkBox, SIGNAL(clicked(bool)), this, SLOT(onCurrentStateChanged(bool)));
	checkBox->installEventFilter(const_cast<CheckboxDelegate*>(this));

	return editor;
}

void CheckboxDelegate::setEditorData(QWidget *editor,
									 const QModelIndex &index) const
{
	bool value = index.model()->data(index, Qt::DisplayRole).toBool();

	QCheckBox *checkBox = static_cast<QCheckBox*>(editor->layout()->itemAt(0)->widget());
	checkBox->setChecked(value);
}

void CheckboxDelegate::setModelData(QWidget *editor, QAbstractItemModel *model,
									const QModelIndex &index) const
{
	QCheckBox *checkBox = static_cast<QCheckBox*>(editor->layout()->itemAt(0)->widget());
	bool value = checkBox->checkState();

	model->setData(index, value);
}

void CheckboxDelegate::updateEditorGeometry(QWidget *editor,
											const QStyleOptionViewItem &option, const QModelIndex &/* index */) const
{
	editor->setGeometry(option.rect);
}

void CheckboxDelegate::onCurrentStateChanged(bool)
{
	QWidget *editor = qobject_cast<QWidget*>(sender());
	emit commitData(editor->parentWidget());
}

QString CheckboxDelegate::displayText(const QVariant &value, const QLocale &) const
{
		if (value.toBool() == true) return QString("True");
		else return QString("False");
}
