#include "DataGrid.hxx"

#include <QApplication>
#include <QList>
#include <QDebug>

int main(int argc, char *argv[])
{

	QApplication a(argc, argv);
	DataGrid w;

	// properties
	w.setKeyColumn(0);
	w.setStyleSheetFile("W:\\sgFw\\style\\DataGrid.qss");

	// unit test
	QList<QVariant> alarmTexts;
	alarmTexts.append(QVariant("Alarm"));
	alarmTexts.append(QVariant("Disturbance"));
	alarmTexts.append(QVariant("Warning"));

	QList<QVariant> alarmValues;
	alarmValues.append(QVariant("System1.scAlarm."));
	alarmValues.append(QVariant("System1.disturbance."));
	alarmValues.append(QVariant("System1.warning."));

	QList<QVariant> alarmColors;
	alarmColors.append(QVariant("#aa0000"));
	alarmColors.append(QVariant("#ffff00"));
	alarmColors.append(QVariant("#ff00ff"));

	// column
	w.addReadonlyColumn("Name");
	w.addStringColumn("Description");
	w.addComboColumn("Alarm Type", alarmTexts, alarmValues, alarmColors, false);
	//w.addComboColumn("Alarm Type", alarmTexts, alarmValues, true);
	w.addBoolColumn("Invert");
	w.addIntColumn("Delay", 0, 150);
	w.addBoolColumn("Alarm");
	w.addStringColumn("Alarm Text");
	w.addButtonColumn("Go", "...");

	w.setColumnWidth(4, 30);

	// data
	QList<QVariant> names;
	names.append(QVariant("Input.001"));
	names.append(QVariant("Input.002"));
	names.append(QVariant("Input.003"));
	names.append(QVariant("Input.004"));
	w.setColumnValues(0, names);

	QList<QVariant> descriptions;
	descriptions.append(QVariant("my description"));
	descriptions.append(QVariant(""));
	descriptions.append(QVariant(""));
	descriptions.append(QVariant(""));
	w.setColumnValues(1, descriptions);

	QList<QVariant> alarmType;
	alarmType.append(QVariant("System1.disturbance."));
	alarmType.append(QVariant(""));
	alarmType.append(QVariant(""));
	alarmType.append(QVariant(""));
	w.setColumnValues(2, alarmType);


	QList<QVariant> inverts;
	inverts.append(QVariant(true));
	inverts.append(QVariant(false));
	inverts.append(QVariant(true));
	inverts.append(QVariant(false));
	w.setColumnValues(3, inverts);

	QList<QVariant> delays;
	delays.append(QVariant(0));
	delays.append(QVariant(50));
	delays.append(QVariant(75));
	delays.append(QVariant(100));
	w.setColumnValues(4, delays);

	QList<QVariant> alarm;
	alarm.append(QVariant(true));
	alarm.append(QVariant(false));
	alarm.append(QVariant(true));
	alarm.append(QVariant(false));
	w.setColumnValues(5, alarm);

	QList<QVariant> rowItems;
	rowItems.append(QVariant("Input.005"));
	rowItems.append(QVariant("the input added by row"));
	rowItems.append(QVariant("System1.disturbance."));
	rowItems.append(QVariant(true));
	rowItems.append(QVariant(125));
	rowItems.append(QVariant(true));
	rowItems.append(QVariant("The Alarm occured"));
	w.addRowValues(rowItems);

	QList<QVariant> rowItems2;
	rowItems2.append(QVariant("Input.005"));
	rowItems2.append(QVariant("the new value"));
	rowItems2.append(QVariant("System1.disturbance."));
	rowItems2.append(QVariant(true));
	rowItems2.append(QVariant(125));
	rowItems2.append(QVariant(true));
	rowItems2.append(QVariant("The Alarm occured"));
	w.addRowValues(rowItems2);


	// data
	QList< QList<QVariant> > data = w.getValues();

	w.setCellEnabled(0, 1, false);
	w.setCellEnabled(1, 1, true);

	w.setRowBackgroundColor(1, "#cccccc");
	w.setRowBackgroundColor(4, "#cccccc");
	w.addContextualMenu("Activation");

    w.setMinimumWidth(900);
    w.setMinimumHeight(500);
	w.show();
	return a.exec();
}
