#include "SortFilterProxyModel.h"

SortFilterProxyModel::SortFilterProxyModel(QObject *parent) :
	QSortFilterProxyModel(parent)
{
	_filter = NULL;
}

SortFilterProxyModel::~SortFilterProxyModel()
{
}

void SortFilterProxyModel::applyFilter(const FilterElement* filter) {
	this->_filter = filter;

    qDebug() << "Invalidate filter";
    invalidateFilter();

}

bool SortFilterProxyModel::filterAcceptsRow(int sourceRow, const QModelIndex &sourceParent) const {

    qDebug() << "Override filterAccepts Row";

		QAbstractItemModel *model = sourceModel();
		// check
		if (!_filter || _filter == NULL) return true;

        return _filter->eval(Context(sourceRow, sourceParent, model));
}
