#include "NotEquals.h"

NotEquals::NotEquals(int columnIndex, const QString &columnName, const QVariant &compare, const QString &compareText, QObject *parent) :
		Comparison(columnIndex, columnName, compare, compareText, parent)
{
}

bool NotEquals::eval(const Context& context) const
{
	QModelIndex index = context.getSourceModel()->index(context.getSourceRow(), _columnIndex, context.getSourceParent());
	return context.getSourceModel()->data(index) != _compare;

}

QString NotEquals::asQuery() const
{
	return QString("%1 != %2").arg(_columnName).arg(_compare.toString());

}


QString NotEquals::name() const
{
		return QString("NOT %1").arg(_compareText);
}

void NotEquals::buildXmlSettings(QDomDocument& dom, QDomElement &element) const
{
		QDomElement notEquals = dom.createElement("NotEquals");
		notEquals.setAttribute("columnIndex", _columnIndex);
		notEquals.setAttribute("columnName", _columnName);
		notEquals.setAttribute("compare", _compare.toString());
		notEquals.setAttribute("compareText", _compareText);
		element.appendChild(notEquals);
}
