#ifndef FILTERELEMENT_H
#define FILTERELEMENT_H

#include <QObject>
#include <QDebug>
#include <QString>
#include <QStringBuilder>
#include <QtXml>

#include "Context.h"

class FilterElement : public QObject
{
	Q_OBJECT
public:
	explicit FilterElement(QObject *parent = 0);
	virtual ~FilterElement();

	virtual bool eval(const Context &context) const = 0;
	virtual QString asQuery() const = 0;
	virtual QString name() const = 0;
	virtual void buildXmlSettings(QDomDocument&, QDomElement&) const = 0;

signals:

public slots:

};

#endif // FILTERELEMENT_H
