#ifndef ANDLIST_H
#define ANDLIST_H

#include <QList>
#include <QSet>

#include "FilterElement.h"

class AndList : public FilterElement
{
	Q_OBJECT
public:
	explicit AndList(QObject *parent = 0);
	virtual ~AndList();

	bool append(FilterElement*);
	void remove(const FilterElement*);
	void clear();
	bool isEmpty();

	virtual bool eval(const Context&) const;
	virtual QString asQuery() const;
	virtual QString name() const;
	virtual void buildXmlSettings(QDomDocument&, QDomElement&) const;

private:
		QList<FilterElement*> children;
		QSet<QString> unique;

signals:

public slots:

};

#endif // ANDLIST_H
