#include "AndList.h"

AndList::AndList(QObject *parent) :
	FilterElement(parent)
{
}

AndList::~AndList()
{
}

bool AndList::append(FilterElement *child)
{
	if (unique.contains(child->asQuery())) return false;

	children.append(child);
	unique.insert(child->asQuery());

	return true;
}

void AndList::remove(const FilterElement *child)
{
	children.removeOne((FilterElement*)child);
	unique.remove(child->asQuery());
}

void AndList::clear()
{
	children.clear();
}

bool AndList::isEmpty()
{
	return children.isEmpty();
}

bool AndList::eval(const Context &context) const
{
	bool result = true;

	foreach( FilterElement* element, children ) {
			result &= element->eval(context);
	}

	return result;
}

QString AndList::asQuery() const
{
	QString query;

	foreach( FilterElement* element, children ) {
			query += element->asQuery();
	}

	return query;
}

QString AndList::name() const
{
	return QString("and list");
}

void AndList::buildXmlSettings(QDomDocument& dom, QDomElement & element) const
{

		QDomElement domAndList = dom.createElement("AndList");
		element.appendChild(domAndList);

		foreach (FilterElement* element, children)
			element->buildXmlSettings(dom, domAndList);

}
