#ifndef _DataGrid_H_
#define _DataGrid_H_

#include <BaseExternWidget.hxx>
#include <DataGrid.hxx>

//--------------------------------------------------------------------------------
// this is the real widget (an ordinary Qt widget), which can also use Q_PROPERTY



//--------------------------------------------------------------------------------
// this is the EWO interface class

class EWO_EXPORT Ewo : public BaseExternWidget
{
	Q_OBJECT

public:
	Ewo(QWidget *parent);

	virtual QWidget *widget() const;
	virtual QStringList signalList() const;
	virtual bool methodInterface(const QString &name, QVariant::Type &retVal, QList<QVariant::Type> &args) const;
	virtual QStringList methodList() const;

public slots:
	virtual QVariant invokeMethod(const QString &name, QList<QVariant> &values, QString &error);

private slots:
	void gridButtonClicked(int row, int column);
	void cellValueChanged(int, int, const QVariant &);
	void contextualMenuClicked(const QString&, int, int);
	void filterChanged();
	void sortChanged();

private:
	DataGrid *baseWidget;
};

#endif
