#include <Ewo.hxx>

#include <QPushButton>
#include <QLayout>
#include <QDateTime>
#include <QPolygon>
#include <QPainter>
#include <QMap>
#include <QCheckBox>
#include <QDebug>

Ewo::Ewo(QWidget *parent) : BaseExternWidget(parent) {
	baseWidget = new DataGrid(parent);

	// connect signal to local slot
	connect(baseWidget, SIGNAL(gridButtonClicked(int, int)), this, SLOT(gridButtonClicked(int, int)));
	connect(baseWidget, SIGNAL(cellValueChanged(int,int,const QVariant&)), this, SLOT(cellValueChanged(int,int,const QVariant&)));
	connect(baseWidget, SIGNAL(contextualMenuClicked(const QString&,int,int)), this, SLOT(contextualMenuClicked(const QString&,int,int)));
	connect(baseWidget, SIGNAL(filterChanged()), this, SLOT(filterChanged()));
	connect(baseWidget, SIGNAL(sortChanged()), this, SLOT(sortChanged()));

}

QWidget *Ewo::widget() const {
	return baseWidget;
}

QStringList Ewo::signalList() const
{
	QStringList list;

	list.append("gridButtonClicked(int row, int column)");
	list.append("cellValueChanged(int row, int column, anytype value)");
	list.append("contextualMenuClicked(string name, int row, int column)");
	list.append("filterChanged()");
	list.append("sortChanged()");

	return list;
}

QStringList Ewo::methodList() const
{
	QStringList list;

	list.append("void addBoolColumn(string name)");
	list.append("void addIntColumn(string name, int minimum, int maximum)");
	list.append("void addStringColumn(string name)");
	list.append("void addReadonlyColumn(string name)");
	list.append("void addComboColumn(string name, dyn_string texts, dyn_anytype values)");
	list.append("void addAssociationColumn(string name, dyn_string texts, dyn_anytype values)");
	list.append("void addColoredComboColumn(string name, dyn_string texts, dyn_anytype values, dyn_anytype colors)");
	list.append("void addColoredAssociationColumn(string name, dyn_string texts, dyn_anytype values, dyn_anytype colors)");
	list.append("void addButtonColumn(string name, string text)");

	list.append("void setColumnHidden(int id, bool hide)");
	list.append("void setColumnWidth(int id, int width)");

	list.append("void addContextualMenu(string name)");

	list.append("void setKeyColumn(int column)");

	list.append("void setStyleSheetFile(string filename)");
	list.append("void setStyleSheet(string styleSheet)");

	list.append("dyn_anytype getColumnValues(int column)");
	list.append("void setColumnValues(int column, dyn_anytype items)");

	list.append("dyn_anytype getRowValues(int row)");
	list.append("void addRowValues(dyn_anytype items)");

	list.append("anytype getValue(int row, int column)");
	list.append("void setValue(int row, int column, anytype value)");

	list.append("int getRow(string key)");
	list.append("int getColumn(string name)");

	list.append("void setCellEnabled(int row, int column, bool enable)");
	list.append("void setCellForegroundColor(int row, int column, string color)");
	list.append("void setRowForegroundColor(int row, string color)");
	list.append("void setColumnForegroundColor(int column, string color)");
	list.append("void setCellBackgroundColor(int row, int column, string color)");
	list.append("void setRowBackgroundColor(int row, string color)");
	list.append("void setColumnBackgroundColor(int column, string color)");

	list.append("dyn_int getSelectedIndex()");
	list.append("dyn_int getSelectedRows()");
	list.append("dyn_int getSelectedColumns()");
	list.append("void clearSelection()");

	list.append("int getSelectionMode()");
	list.append("void setSelectionMode(int)");
	list.append("bool isSortingEnabled()");
	list.append("void setSortingEnabled(bool)");

	list.append("void clear()");
	list.append("void connectDataEvents()");
	list.append("void disconnectDataEvents()");

	list.append("void copy()");
	list.append("void paste()");

	list.append("string buildXmlSettings()");
	list.append("void applyXmlSettings(string)");

	return list;
}

bool Ewo::methodInterface(const QString &name, QVariant::Type &retVal,
								 QList<QVariant::Type> &args) const
{

	if ( name == "addBoolColumn" || name == "addStringColumn" || name == "addReadonlyColumn" ) {
		retVal = QVariant::Invalid;
		args.append(QVariant::String);
		return true;
	} else if ( name == "addIntColumn" ) {
		retVal = QVariant::Invalid;
		args.append(QVariant::String);
		args.append(QVariant::Int);
		args.append(QVariant::Int);
		return true;
	} else if ( name == "addComboColumn" ) {
		retVal = QVariant::Invalid;
		args.append(QVariant::String);
		args.append(QVariant::StringList);
		args.append(QVariant::List);
		return true;
	} else if ( name == "addAssociationColumn" ) {
		retVal = QVariant::Invalid;
		args.append(QVariant::String);
		args.append(QVariant::StringList);
		args.append(QVariant::List);
		return true;
	} else if ( name == "addColoredComboColumn" ) {
		retVal = QVariant::Invalid;
		args.append(QVariant::String);
		args.append(QVariant::StringList);
		args.append(QVariant::List);
		args.append(QVariant::List);
		return true;
	} else if ( name == "addColoredAssociationColumn" ) {
		retVal = QVariant::Invalid;
		args.append(QVariant::String);
		args.append(QVariant::StringList);
		args.append(QVariant::List);
		args.append(QVariant::List);
		return true;
	} else if ( name == "addButtonColumn" ) {
		retVal = QVariant::Invalid;
		args.append(QVariant::String);
		args.append(QVariant::String);
		return true;
	} else if ( name == "addContextualMenu" ) {
		retVal = QVariant::Invalid;
		args.append(QVariant::String);
		return true;
	} else if ( name == "setKeyColumn" ) {
		retVal = QVariant::Invalid;
		args.append(QVariant::Int);
		return true;
	} else if ( name == "setColumnHidden" ) {
		retVal = QVariant::Invalid;
		args.append(QVariant::Int);
		args.append(QVariant::Bool);
		return true;
	} else if ( name == "setColumnWidth" ) {
		retVal = QVariant::Invalid;
		args.append(QVariant::Int);
		args.append(QVariant::Int);
		return true;
	} else if ( name == "getValue" ) {
		args.append(QVariant::Int);
		args.append(QVariant::Int);
		retVal = QVariant::UserType;
		return true;
	} else if ( name == "setValue" ) {
		retVal = QVariant::Invalid;
		args.append(QVariant::Int);
		args.append(QVariant::Int);
		args.append(QVariant::UserType);
		return true;
	} else if ( name == "getRow" ) {
		args.append(QVariant::String);
		retVal = QVariant::UserType;
		return true;
	} else if ( name == "getColumn" ) {
		args.append(QVariant::String);
		retVal = QVariant::UserType;
		return true;
	} else if ( name == "setColumnValues" ) {
		retVal = QVariant::Invalid;
		args.append(QVariant::Int);
		args.append(QVariant::List);
		return true;
	} else if ( name == "addRowValues" ) {
		retVal = QVariant::Invalid;
		args.append(QVariant::List);
		return true;
	} else if ( name == "getColumnValues" ) {
		retVal = QVariant::List;
		args.append(QVariant::Int);
		return true;
	} else if ( name == "getRowValues" ) {
		retVal = QVariant::List;
		args.append(QVariant::Int);
		return true;
	} else if ( name == "setCellEnabled" ) {
		retVal = QVariant::Invalid;
		args.append(QVariant::Int);
		args.append(QVariant::Int);
		args.append(QVariant::Bool);
		return true;
	} else if ( name == "setStyleSheetFile" ) {
		retVal = QVariant::Invalid;
		args.append(QVariant::String);
		return true;
	} else 		if ( name == "setStyleSheet" ) {
		retVal = QVariant::Invalid;
		args.append(QVariant::String);
		return true;
	} else if ( name == "setCellForegroundColor" ) {
		retVal = QVariant::Invalid;
		args.append(QVariant::Int);
		args.append(QVariant::Int);
		args.append(QVariant::String);
		return true;
	} else if ( name == "setRowForegroundColor" ) {
		retVal = QVariant::Invalid;
		args.append(QVariant::Int);
		args.append(QVariant::String);
		return true;
	} else if ( name == "setColumnForegroundColor" ) {
		retVal = QVariant::Invalid;
		args.append(QVariant::Int);
		args.append(QVariant::String);
		return true;
	} else if ( name == "setCellBackgroundColor" ) {
		retVal = QVariant::Invalid;
		args.append(QVariant::Int);
		args.append(QVariant::Int);
		args.append(QVariant::String);
		return true;
	} else if ( name == "setRowBackgroundColor" ) {
		retVal = QVariant::Invalid;
		args.append(QVariant::Int);
		args.append(QVariant::String);
		return true;
	} else if ( name == "setColumnBackgroundColor" ) {
		retVal = QVariant::Invalid;
		args.append(QVariant::Int);
		args.append(QVariant::String);
		return true;
	} else if ( name == "getSelectedIndex" ) {
		retVal = QVariant::Invalid;
		return true;
	} else if ( name == "getSelectedRows" ) {
		retVal = QVariant::Invalid;
		return true;
	} else if ( name == "getSelectedColumns" ) {
		retVal = QVariant::Invalid;
		return true;
	} else if ( name == "clearSelection" ) {
		retVal = QVariant::Invalid;
		return true;
	} else if ( name == "getSelectionMode" ) {
		retVal = QVariant::Int;
		return true;
	} else if ( name == "setSelectionMode" ) {
		retVal = QVariant::Invalid;
		args.append(QVariant::Int);
		return true;
	} else if ( name == "isSortingEnabled" ) {
		retVal = QVariant::Bool;
		return true;
	} else if ( name == "setSortingEnabled" ) {
		retVal = QVariant::Invalid;
		args.append(QVariant::Bool);
		return true;
	} else if (name == "clear" ) {
		retVal = QVariant::Invalid;
		return true;
	} else if ( name == "connectDataEvents" ) {
		retVal = QVariant::Invalid;
		return true;
	} else if ( name == "disconnectDataEvents" ) {
		retVal = QVariant::Invalid;
		return true;
	} else if ( name == "copy" ) {
		retVal = QVariant::Invalid;
		return true;
	} else if ( name == "paste" ) {
		retVal = QVariant::Invalid;
		return true;
	} else if ( name == "buildXmlSettings" ) {
		retVal = QVariant::String;
		return true;
	} else if ( name == "applyXmlSettings" ) {
		retVal = QVariant::Invalid;
		args.append(QVariant::String);
		return true;
	}

	return false;
}

//--------------------------------------------------------------------------------

QVariant Ewo::invokeMethod(const QString &name, QList<QVariant> &values, QString &error)
{

	if ( name == "addBoolColumn" ) {
		if ( !hasNumArgs(name, values, 1, error) ) return QVariant();
		baseWidget->addBoolColumn(values[0].value<QString>());
		return QVariant();
	} else if ( name == "addStringColumn" ) {
		if ( !hasNumArgs(name, values, 1, error) ) return QVariant();
		baseWidget->addStringColumn(values[0].value<QString>());
		return QVariant();
	}else if ( name == "addReadonlyColumn" ) {
		if ( !hasNumArgs(name, values, 1, error) ) return QVariant();
		baseWidget->addReadonlyColumn(values[0].value<QString>());
		return QVariant();
	} else if ( name == "addIntColumn" ) {
		if ( !hasNumArgs(name, values, 3, error) ) return QVariant();
		baseWidget->addIntColumn(values[0].value<QString>(), values[1].value<int>(), values[2].value<int>());
		return QVariant();
	} else if ( name == "addComboColumn" ) {
		if ( !hasNumArgs(name, values, 3, error) ) return QVariant();
		baseWidget->addComboColumn(values[0].value<QString>(), values[1].toList(), values[2].toList(), false);
		return QVariant();
	} else if ( name == "addAssociationColumn" ) {
		if ( !hasNumArgs(name, values, 3, error) ) return QVariant();
		baseWidget->addComboColumn(values[0].value<QString>(), values[1].toList(), values[2].toList(), true);
		return QVariant();
	} else if ( name == "addColoredComboColumn" ) {
		if ( !hasNumArgs(name, values, 4, error) ) return QVariant();
		baseWidget->addComboColumn(values[0].value<QString>(), values[1].toList(), values[2].toList(), values[3].toList(), false);
		return QVariant();
	} else if ( name == "addColoredAssociationColumn" ) {
		if ( !hasNumArgs(name, values, 4, error) ) return QVariant();
		baseWidget->addComboColumn(values[0].value<QString>(), values[1].toList(), values[2].toList(), values[3].toList(), true);
		return QVariant();
	} else if ( name == "addButtonColumn" ) {
		if ( !hasNumArgs(name, values, 2, error) ) return QVariant();
		baseWidget->addButtonColumn(values[0].value<QString>(), values[1].value<QString>());
		return QVariant();
	} else if ( name == "addContextualMenu" ) {
		if ( !hasNumArgs(name, values, 1, error) ) return QVariant();
		baseWidget->addContextualMenu(values[0].value<QString>());
		return QVariant();
	} else if ( name == "setKeyColumn" ) {
		if ( !hasNumArgs(name, values, 1, error) ) return QVariant();
		baseWidget->setKeyColumn(values[0].toInt());
		return QVariant();
	} else if ( name == "setColumnHidden" ) {
		if ( !hasNumArgs(name, values, 2, error) ) return QVariant();
		baseWidget->setColumnHidden(values[0].toInt(), values[1].toBool());
		return QVariant();
	} else if ( name == "setColumnWidth" ) {
		if ( !hasNumArgs(name, values, 2, error) ) return QVariant();
		baseWidget->setColumnWidth(values[0].toInt(), values[1].toInt());
		return QVariant();
	} else if ( name == "getValue" ) {
		if ( !hasNumArgs(name, values, 2, error) ) return QVariant();
		return baseWidget->getValue(values[0].toInt(), values[1].toInt());
	} else if ( name == "setValue" ) {
		if ( !hasNumArgs(name, values, 3, error) ) return QVariant();
		baseWidget->setValue(values[0].toInt(), values[1].toInt(), values[2]);
		return QVariant();
	} else if ( name == "getRow" ) {
		if ( !hasNumArgs(name, values, 1, error) ) return QVariant();
		return baseWidget->getRow(values[0].toString());
	} else if ( name == "getColumn" ) {
		if ( !hasNumArgs(name, values, 1, error) ) return QVariant();
		return baseWidget->getColumn(values[0].toString());
	} else if ( name == "setColumnValues" ) {
		if ( !hasNumArgs(name, values, 2, error) ) return QVariant();
		baseWidget->setColumnValues(values[0].value<int>(), values[1].toList());
		return QVariant();
	} else if ( name == "addRowValues" ) {
		if ( !hasNumArgs(name, values, 1, error) ) return QVariant();
		baseWidget->addRowValues(values[0].toList());
		return QVariant();
	} else if ( name == "getColumnValues" ) {
		if ( !hasNumArgs(name, values, 1, error) ) return QVariant();
		return baseWidget->getColumnValues(values[0].value<int>());
	} else if ( name == "getRowValues" ) {
		if ( !hasNumArgs(name, values, 1, error) ) return QVariant();
		return baseWidget->getRowValues(values[0].value<int>());
	} else if ( name == "setCellEnabled" ) {
		if ( !hasNumArgs(name, values, 3, error) ) return QVariant();
		baseWidget->setCellEnabled(values[0].toInt(), values[1].toInt(), values[2].toBool());
		return QVariant();
	} else if ( name == "setCellForegroundColor" ) {
		if ( !hasNumArgs(name, values, 3, error) ) return QVariant();
		baseWidget->setCellForegroundColor(values[0].toInt(), values[1].toInt(), values[2].toString());
		return QVariant();
	} else if ( name == "setRowForegroundColor" ) {
		if ( !hasNumArgs(name, values, 2, error) ) return QVariant();
		baseWidget->setRowForegroundColor(values[0].toInt(), values[1].toString());
		return QVariant();
	} else if ( name == "setColumnForegroundColor" ) {
		if ( !hasNumArgs(name, values, 2, error) ) return QVariant();
		baseWidget->setColumnForegroundColor(values[0].toInt(), values[1].toString());
		return QVariant();
	} else if ( name == "setCellBackgroundColor" ) {
		if ( !hasNumArgs(name, values, 3, error) ) return QVariant();
		baseWidget->setCellBackgroundColor(values[0].toInt(), values[1].toInt(), values[2].toString());
		return QVariant();
	} else if ( name == "setRowBackgroundColor" ) {
		if ( !hasNumArgs(name, values, 2, error) ) return QVariant();
		baseWidget->setRowBackgroundColor(values[0].toInt(), values[1].toString());
		return QVariant();
	} else if ( name == "setColumnBackgroundColor" ) {
		if ( !hasNumArgs(name, values, 2, error) ) return QVariant();
		baseWidget->setColumnBackgroundColor(values[0].toInt(),  values[1].toString());
		return QVariant();
	} else if ( name == "setStyleSheetFile" ) {
		if ( !hasNumArgs(name, values, 1, error) ) return QVariant();
		baseWidget->setStyleSheetFile(values[0].toString());
		return QVariant();
	} else if ( name == "setStyleSheet" )	{
		if ( !hasNumArgs(name, values, 1, error) ) return QVariant();
		baseWidget->setStyleSheet(values[0].toString());
		return QVariant();
	} else if ( name == "getSelectedIndex" ) {
		if ( !hasNumArgs(name, values, 0, error) ) return QVariant();
		return baseWidget->getSelectedIndex();
	} else if ( name == "getSelectedRows" ) {
		if ( !hasNumArgs(name, values, 0, error) ) return QVariant();
		return baseWidget->getSelectedRows();
	} else if ( name == "getSelectedColumns" ) {
		if ( !hasNumArgs(name, values, 0, error) ) return QVariant();
		return baseWidget->getSelectedColumns();
	} else if ( name == "clearSelection" ) {
		if ( !hasNumArgs(name, values, 0, error) ) return QVariant();
		baseWidget->clearSelection();
		return QVariant();
	} else if ( name == "getSelectionMode" ) {
		if ( !hasNumArgs(name, values, 0, error) ) return QVariant();
		return baseWidget->getSelectionMode();
	} else if ( name == "setSelectionMode" ) {
		if ( !hasNumArgs(name, values, 1, error) ) return QVariant();
		baseWidget->setSelectionMode((QAbstractItemView::SelectionMode)values[0].toInt());
		return QVariant();
	} else if ( name == "isSortingEnabled" ) {
		if ( !hasNumArgs(name, values, 0, error) ) return QVariant();
		return baseWidget->isSortingEnabled();
	} else if ( name == "setSortingEnabled" ) {
		if ( !hasNumArgs(name, values, 1, error) ) return QVariant();
		baseWidget->setSortingEnabled(values[0].toBool());
		return QVariant();
	} else if ( name == "clear" ) {
		if ( !hasNumArgs(name, values, 0, error) ) return QVariant();
		baseWidget->clear();
		return QVariant();
	} else if ( name == "connectDataEvents" ) {
		if ( !hasNumArgs(name, values, 0, error) ) return QVariant();
		baseWidget->connectDataEvents();
		return QVariant();
	} else if ( name == "disconnectDataEvents" ) {
		if ( !hasNumArgs(name, values, 0, error) ) return QVariant();
		baseWidget->disconnectDataEvents();
		return QVariant();
	} else if ( name == "copy" ) {
		if ( !hasNumArgs(name, values, 0, error) ) return QVariant();
		baseWidget->copy();
		return QVariant();
	} else if ( name == "paste" ) {
		if ( !hasNumArgs(name, values, 0, error) ) return QVariant();
		baseWidget->paste();
		return QVariant();
	} else if ( name == "buildXmlSettings" ) {
		if ( !hasNumArgs(name, values, 0, error) ) return QVariant();
		return baseWidget->buildXmlSettings();
	} else if ( name == "applyXmlSettings" ) {
		if ( !hasNumArgs(name, values, 1, error) ) return QVariant();
		baseWidget->applyXmlSettings(values[0].toString());
		return QVariant();
	}

	return QVariant();
}

// slots
void Ewo::gridButtonClicked(int row, int column) {
	QList<QVariant> values;
	values << QVariant(row) << QVariant(column);

	emit signal("gridButtonClicked", values);
}

void Ewo::cellValueChanged(int row, int column, const QVariant &value) {
	QList<QVariant> values;
	values << QVariant(row) << QVariant(column) << value;

	emit signal("cellValueChanged", values);
}

void Ewo::contextualMenuClicked(const QString& name, int row, int column) {
	QList<QVariant> values;
	values << QVariant(name) << QVariant(row) << QVariant(column);

	emit signal("contextualMenuClicked", values);
}

void Ewo::filterChanged() {
    emit signal("filterChanged", 0);
}

void Ewo::sortChanged() {
    emit signal("sortChanged", 0);
}

