#ifndef SPINBOXDELEGATE_HXX
#define SPINBOXDELEGATE_HXX

#include <QStyledItemDelegate>
#include <QModelIndex>
#include <QObject>
#include <QSize>
#include <QSpinBox>

class SpinboxDelegate : public QStyledItemDelegate
{
	Q_OBJECT

public:
	SpinboxDelegate(int minimum, int maximum, QObject *parent = 0);

	QWidget *createEditor(QWidget *parent, const QStyleOptionViewItem &option,
						  const QModelIndex &index) const;

	void setEditorData(QWidget *editor, const QModelIndex &index) const;
	void setModelData(QWidget *editor, QAbstractItemModel *model,
					  const QModelIndex &index) const;

	void updateEditorGeometry(QWidget *editor,
							  const QStyleOptionViewItem &option, const QModelIndex &index) const;

private slots:
	void onCurrentStateChanged(int);

private:
	int minimum;
	int maximum;
};



#endif // SPINBOXDELEGATE_HXX
