#ifndef COMBOBOXDELEGATE_HXX
#define COMBOBOXDELEGATE_HXX

#include <QStyledItemDelegate>
#include <QItemDelegate>

class ComboboxDelegate : public QStyledItemDelegate
{
	Q_OBJECT

public:
	ComboboxDelegate(QList<QVariant> texts, QList<QVariant> values, bool readonly=false, QObject *parent = 0);
	ComboboxDelegate(QList<QVariant> texts, QList<QVariant> values, QList<QVariant> colors, bool readonly=false, QObject *parent = 0);

	void paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const;
	QWidget *createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index) const;
	void setEditorData(QWidget *editor, const QModelIndex &index) const;
	void setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index) const;
	void updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index) const;

	virtual QString displayText(const QVariant &value, const QLocale &locale) const;

private slots:
	void onCurrentStateChanged(int);

private:
	QList<QVariant> texts;
	QList<QVariant> values;
	QList<QVariant> colors;
	bool readonly;

};

#endif // COMBOBOXDELEGATE_HXX
