#include "ButtonDelegate.hxx"

#include <QApplication>
#include <QMouseEvent>
#include <QPainter>
#include <QDialog>

#include <QDebug>

ButtonDelegate::ButtonDelegate(const QString &text, DataGrid *dataGrid, QObject *parent)
	: QStyledItemDelegate(parent) {
	this->name = text;
	this->dataGrid = dataGrid;
}

void ButtonDelegate::paint(QPainter *painter,
							 const QStyleOptionViewItem &option,
							 const QModelIndex &index) const {

	QStyleOptionButton button;
	button.rect = option.rect;
	button.text = "...";
	button.state = option.state | QStyle::State_Enabled;

	QColor background = index.model()->data(index, Qt::BackgroundRole).value<QColor>();
	if (background.isValid()) painter->fillRect(option.rect, background);

	QColor foreground = index.model()->data(index, Qt::ForegroundRole).value<QColor>();
	if (foreground.isValid()) painter->setPen(foreground);

	QApplication::style()->drawControl( QStyle::CE_PushButton, &button, painter);


}

bool ButtonDelegate::editorEvent(QEvent *event,
								 QAbstractItemModel * /*model*/,
								 const QStyleOptionViewItem & /*option*/,
								 const QModelIndex &index)
{
	if( event->type() == QEvent::MouseButtonRelease )
	{
		this->dataGrid->fireGridButtonClicked(index.row(), index.column());
		return true;
	}

	return false;
}

