#ifndef MYWIDGET_HXX
#define MYWIDGET_HXX

// #include <BaseExternWidget.hxx>

#include <QStandardItemModel>
#include <QMenu>
#include <QMap>
#include <QtXml>
#include <QHeaderView>

#include "Filter/SortFilterProxyModel.h"
#include "Filter/AbstractTree/FilterElement.h"
#include "Filter/AbstractTree/AndList.h"
#include "Filter/AbstractTree/Equals.h"
#include "Filter/AbstractTree/NotEquals.h"

#include "FlowLayout.h"
#include "Filter/FilterWidget.h"

struct FilterAction {
	enum Enum {
		CLEAR, EQUALS, NOT_EQUALS, CUSTOM
	};
};

Q_DECLARE_METATYPE(FilterAction::Enum)

class DataGrid : public QWidget {
	// MOCK Object
	Q_OBJECT

	// property for MOC
	// - tableView
	Q_PROPERTY( bool alternatingRow READ getAlternatingRow WRITE setAlternatingRow DESIGNABLE true )

	// - header
	Q_PROPERTY( int rowDefaultSize READ getRowDefaultSize WRITE setRowDefaultSize DESIGNABLE true )
	Q_PROPERTY( int columnDefaultSize READ getColumnDefaultSize WRITE setColumnDefaultSize DESIGNABLE true )
	Q_PROPERTY( QHeaderView::ResizeMode rowResizeMode READ getRowResizeMode WRITE setRowResizeMode DESIGNABLE true )
	Q_PROPERTY( QHeaderView::ResizeMode columnResizeMode READ getColumnResizeMode WRITE setColumnResizeMode DESIGNABLE true )
	Q_PROPERTY( QHeaderView::SelectionMode selectionMode READ getSelectionMode WRITE setSelectionMode DESIGNABLE true )
	Q_PROPERTY( QHeaderView::SelectionBehavior selectionBehavior READ getSelectionBehavior WRITE setSelectionBehavior DESIGNABLE true )
	Q_PROPERTY( bool sortingEnabled READ isSortingEnabled WRITE setSortingEnabled DESIGNABLE true )

	// - non designable
	Q_PROPERTY( int rowCount READ getRowCount DESIGNABLE false )
	Q_PROPERTY( int columnCount READ getColumnCount DESIGNABLE false )

public:
	explicit DataGrid(QWidget *parent = 0);
	~DataGrid();

	// columns
	void addBoolColumn(const QString &name);
	void addIntColumn(const QString &name, int minimum, int maximum);
	void addStringColumn(const QString &name);
	void addReadonlyColumn(const QString &name);
		void addComboColumn(const QString &name, const QList<QVariant> &texts, const QList<QVariant> &values, bool readonly);
		void addComboColumn(const QString &name, const QList<QVariant> &texts, const QList<QVariant> &values, const QList<QVariant> &colors, bool readonly);
	void addButtonColumn(const QString &name, const QString &text);

	void setColumnHidden(int id, bool hide);
	void setColumnWidth(int id, int width);

	// values
		void setColumnValues(int index, const QList<QVariant> &values);
		void addRowValues(const QList<QVariant> &values);
	void setKeyColumn(int);

	QList<QVariant> getColumnValues(int column);
	QList<QVariant> getRowValues(int row);

	QVariant getValue(int row, int column);
	void setValue(int row, int column, QVariant &value);

	int getRow(const QString& key);
	int getColumn(const QString& name);

	// colors
	void setCellForegroundColor(int, int, const QString&);
	void setRowForegroundColor(int, const QString&);
	void setColumnForegroundColor(int, const QString&);

	void setCellBackgroundColor(int, int, const QString&);
	void setRowBackgroundColor(int, const QString&);
	void setColumnBackgroundColor(int, const QString&);

	// contextual
	void addContextualMenu(const QString&);

	// unusable with EWO interface
	QList< QList<QVariant> > getValues();
	void setValues(QList< QList<QVariant> > values);

	// enable
	void setCellEnabled(int row, int column, bool enable);

	// style
	void setStyleSheetFile(const QString &filename);
	void setStyleSheet(const QString &styleSheet);

	// selection
	QList<QVariant> getSelectedIndex();
	QList<QVariant> getSelectedRows();
	QList<QVariant> getSelectedColumns();
	void clearSelection();

	// tools
	void copy();
	void paste();

	// properties
	int getRowCount() { return this->model->rowCount(); }
	int getColumnCount() { return this->model->columnCount(); }

	bool getAlternatingRow () { return tableView->alternatingRowColors(); }
	void setAlternatingRow (bool value) { tableView->setAlternatingRowColors(value); }

	int getRowDefaultSize () { return tableView->verticalHeader()->defaultSectionSize(); }
	void setRowDefaultSize (int value) { tableView->verticalHeader()->setDefaultSectionSize(value); }

	int getColumnDefaultSize () { return tableView->horizontalHeader()->defaultSectionSize(); }
	void setColumnDefaultSize (int value) { tableView->horizontalHeader()->setDefaultSectionSize(value); }

	QHeaderView::ResizeMode getRowResizeMode () { return tableView->verticalHeader()->resizeMode(0); }
	void setRowResizeMode (QHeaderView::ResizeMode value) { tableView->verticalHeader()->setResizeMode(value); }

	QHeaderView::ResizeMode getColumnResizeMode () { return tableView->horizontalHeader()->resizeMode(0); }
	void setColumnResizeMode (QHeaderView::ResizeMode value) { tableView->horizontalHeader()->setResizeMode(value); }

	QHeaderView::SelectionMode getSelectionMode () { return tableView->selectionMode(); }
	void setSelectionMode (QHeaderView::SelectionMode value) { tableView->setSelectionMode(value); }

	QHeaderView::SelectionBehavior getSelectionBehavior () { return tableView->selectionBehavior(); }
	void setSelectionBehavior (QHeaderView::SelectionBehavior value) { tableView->setSelectionBehavior(value); }

	bool isSortingEnabled () { return tableView->isSortingEnabled(); }
	void setSortingEnabled (bool value) { tableView->setSortingEnabled(value); }

	// method
	void clear() { this->model->clear(); }
	void connectDataEvents();
	void disconnectDataEvents();

	// 	filter and sort
	QString buildXmlSettings();
	void applyXmlSettings(const QString&);
	void applyFilter();
	void applySortOrder();

	// override
	virtual void keyPressEvent(QKeyEvent *key);

	// event
	virtual void fireGridButtonClicked(int row, int column);

private:
	QTableView* tableView;
	QFrame* filterStack;
	QStandardItemModel *model;
	SortFilterProxyModel *proxyModel;
	AndList* filter;
	int keyColumn;
	QMap<QString, int> keyIndex;
	QList<QString> contextualMenus;
	bool isWriting;

	int currentColumnIndex;
	QString currentColumnName;
	QVariant currentValue;
	QString currentText;
	QPoint currentPosition;

	void invalidate();

	void createMenu(QMenu*, const QString&, FilterAction::Enum);
	void addFilter(FilterElement* );
	void addFilterWidget(const QString &, const FilterElement *);
	void clearFilterWidget();

	QModelIndex getModelIndexFromProxy(int, int);

signals:
	void gridButtonClicked(int row, int column);
	void cellValueChanged(int row, int column, const QVariant &value);
	void contextualMenuClicked(const QString &name, int row, int column);
	void filterChanged();
	void sortChanged();

private slots:
	void onDataChanged(const QModelIndex&, const QModelIndex&);
	void onCustomMenuRequested(QPoint pos);
	void onMenuAction(QAction*);
	void onFilterClosed(FilterWidget*);
	void onSortOrderChanged(int, Qt::SortOrder);

};

#endif // MYWIDGET_HXX
