#include <TcpServerExternHdl.hxx>
#include <TcpServer.hxx>
#include <IntegerVar.hxx>
#include <UIntegerVar.hxx>
#include <TextVar.hxx>
#include <Controller.hxx>

//------------------------------------------------------------------------------

static FunctionListRec fnList[] =
{
  { INTEGER_VAR, "tcpServer", "(unsigned port, string callbackFunc)", false }
};

CTRL_EXTENSION(TcpServerExternHdl, fnList)

//------------------------------------------------------------------------------

const Variable *TcpServerExternHdl::execute(ExecuteParamRec &param)
{
  enum
  {
    F_tcpServer  = 0
  };

  static IntegerVar integerVar;

  switch ( param.funcNum )
  {
    // ---------------------------------------------------------------------
    case F_tcpServer:
    {
      param.thread->clearLastError();

      // check number of arguments
      if ( !param.args || (param.args->getNumberOfItems() != 2) )
      {
        ErrHdl::error(ErrClass::PRIO_WARNING,
                      ErrClass::ERR_CONTROL, ErrClass::ARG_MISSING,
                      param.thread->getLocation(), param.funcName);

        integerVar.setValue(-1); return &integerVar;
      }

      // get first and second argument
      UIntegerVar port;
      TextVar func;
      port = *(param.args->getFirst()->evaluate(param.thread));
      func = *(param.args->getNext ()->evaluate(param.thread));

      if ( ! Controller::thisPtr->findFunc(func, param.thread->getScript()) )
      {
        ErrHdl::error(ErrClass::PRIO_WARNING,
                      ErrClass::ERR_CONTROL, ErrClass::UNDEFD_FUNC,
                      param.clientData->getLocation(), param.funcName, func);

        integerVar.setValue(-1);
        return &integerVar;
      }

      TcpServer *server = new TcpServer(param.thread->getScript(), port, func);

      if ( ! server->startAllowed() )
      {
        delete server;
        integerVar.setValue(-1);
        return &integerVar;
      }

      param.thread->getScript()->startModule(server);

      integerVar.setValue(0);
      return &integerVar;
    }

    // ---------------------------------------------------------------------
    default:
      integerVar.setValue(-1);
      return &integerVar;
  }
}

//--------------------------------------------------------------------------------
