//*********************************************************
// Copyright  2018 by FM . Please copy and distribute. "Share the fun"
//*********************************************************
// Description:
// Contains functions to:
//
// - transforms all panels into an (temporary) XMl format
// - Isolate the script code from a panel
//
// ********************************************************

//module:TopAce_XML
//prefix:ta_XML_

//****************************************************
// Description: 
//   This function copys all panels to a temp folder and makes the xml files
//
//   Will create a folder 'TopAceTempXML' in the \panels
//   folders and will then the UI to convert all panels copied
//   there into an XML file
//   ( so that we can then isolate the script from it)
//
// Returns:
// void
//
//****************************************************
void ta_XML_PanelsToXML ()
{
  string strPanelsFolder = getPath( PANELS_REL_PATH );
  string strXMLFolder   = "TopAceTempXML";
  
  string strUI = "wccoaui";
  
  // Read all and folders in the \panels folder
  dyn_string strFolders = getFileNames( strPanelsFolder, "*", FILTER_DIRS  );

  // It could be that our strFolders contains the folder 'strXMLFolder' made in an earlier session
  // Also, we need to remove the folders "." and ".."
  dynRemove(strFolders,dynContains(strFolders,"."));
  dynRemove(strFolders,dynContains(strFolders,".."));  
  
  if( dynContains(strFolders,strXMLFolder) > 0 )
  {
    dynRemove(strFolders,dynContains(strFolders,strXMLFolder));   
    
    // First remove any previous strXMLFolder folder
    rmdir( strPanelsFolder + strXMLFolder, true );
  }  
  
  
  // Make a folder where we'll store a temporary XML converted copy of each panel
  // (because we do not want to touch the original files)
  mkdir( strPanelsFolder + strXMLFolder ); 
  
  // Now copy all files into our temporary XMl folder
  copyAllFiles( strPanelsFolder, strPanelsFolder + strXMLFolder );
  
  // Now copy each of the sub folders
  for( int t = 1; t <= dynlen( strFolders ); t++)
  {
    mkdir( strPanelsFolder + strXMLFolder + "/" + strFolders[t] );
    copyAllFilesRecursive( strPanelsFolder + strFolders[t], strPanelsFolder + strXMLFolder + "/" + strFolders[t] );
  }
  
  // now make the XML files from the *.pnl files

  system( strUI + " -n -proj " + PROJ + " -xmlConvert -p " +  strXMLFolder + " -o" );
}

//****************************************************
// Description: 
//  Takes a relative path to a panel, then looks in the folder
//  "TopAceTempXML" where the panel has eben turned into XML'
//
//  Will then parse the XML file isolating all the script lines
//
// Returns:
// void
//
//****************************************************

string ta_XML_IsolateScriptFromPanel( 
  string strPanel      // Relative path to a panel
)
{
  string strScript;
  string strFileContents;
  bool bAddingScript = false;
  
  // where are the XML versions of the panels stored
  string strTempXML = getPath( PANELS_REL_PATH ) + "TopAceTempXML/";
  
  // we have the relative name to a panel
  // and now have to locate the XML exported copy
  // in "TopAceTempXML"
  string strPanelXML = strTempXML + strPanel;
  
  strreplace( strPanelXML, ".pnl", ".xml" );
  
  DebugN( "Isolating script from : " + strPanelXML );

  fileToString( strPanelXML, strFileContents );
  dyn_string dstrLines = strsplit( strFileContents, "\n" );

  // A script in the XML will look like:
  //   <events>
  //   <script name="ScopeLib" isEscaped="1"><![CDATA[//*** Header
  //   ^^^^^^^^^^
  //   // This is the main window for TopAce
  //   bool bDoMetrics;   // TRUE when we need to analyse scripot metrics as well
  //  
  //   ]]></script>
  //  ^^^^^^^^^^^^
  
 
  for( int t = 1; t <= dynlen(  dstrLines ); t++)
  {
    string strLine = dstrLines[t];
    
    // The magic sequence < script name=" marks the beginning
    // of the script code
    if( strpos( strLine, "<" "script name=" ) >= 0 )
    {
      bAddingScript = true;
      
      int iPos = strpos( strLine, "[""CDATA[" );
      if( iPos > 0 )
      {
        strLine = substr( strLine, iPos + 7 );
      }
    }

    
    // The magic word </script> marks the end of the script code
    if( strpos( strLine, "<""/script>" ) >= 0 )
    {
     
      // The line could be something like:
      // }]]
      //  ^^ we make sure to add the last "}"
      int iPos = strpos( strLine, "]]" );
      if( iPos > 0 )
      {
        strLine = substr( strLine, 0, iPos );
        strScript += strLine;
      }
      
      bAddingScript = false;
      strLine += "\n";
    }
    
    if( bAddingScript )
    {
      strScript += strLine + "\n";
    }
  } 
  
  return strScript; 
}
