//*********************************************************
// Copyright  2018 by FM . Please copy and distribute. "Share the fun"
//*********************************************************
// Description:
//  This is the main file for TopAce containing
//  just some fucntions to show and select the
//  checkbox in the TopAce menu
//
// ********************************************************

#uses "CtrlPv2admin"           // contains functions to read the config file

//module:TopAce_Menu
//prefix:TopAceMenu_

// The following hold the id's for the menu items
global int g_TopAce_iMenuOption_Metrics = 0;       // Do they want us to analyse the metrics of script (opr panel)
global int g_TopAce_iMenuOption_GraphTopAce = 0;   // Include TopAce in the graph


global bool g_TopAce_bDoMetrics;
global bool g_TopAce_bGraphTopAce;

void TopAceMenu_StoreMenuChoices()
{
  string strSection = "topace";
  
  // Open a file in the data folder
  string strConfigFile = getPath( CONFIG_REL_PATH ) + "topace.def";
  
  DebugN( "Storing the TopAce menu items" );
  
  // Read the values from the menu
  // and write them to the config file
  g_TopAce_bDoMetrics = moduleGetAction( g_TopAce_iMenuOption_Metrics, "checked" );
  
  paCfgDeleteValue( strConfigFile, strSection, "dometrics" );
  paCfgInsertValue( strConfigFile, strSection, "dometrics", (int)g_TopAce_bDoMetrics );

  // Read the value to include TopAce in our graph
  g_TopAce_bGraphTopAce = moduleGetAction( g_TopAce_iMenuOption_GraphTopAce, "checked" );

  paCfgDeleteValue( strConfigFile, strSection, "graphtopace" );
  paCfgInsertValue( strConfigFile, strSection, "graphtopace", (int)g_TopAce_bGraphTopAce );

  
}


void TopAceMenu_LoadMenuChoices()
{
  int iValue;
  
  // Open a file in the data folder
  string strConfigFile = getPath( CONFIG_REL_PATH ) + "topace.def";

  // Read the entry in the config file
  paCfgReadValue( strConfigFile, "topace", "dometrics" ,iValue );  
  g_TopAce_bDoMetrics = (iValue == 1);

  iValue = 0;
  paCfgReadValue( strConfigFile, "topace", "graphtopace" ,iValue );  
  g_TopAce_bGraphTopAce = (iValue == 1);
  
  
}

// ********************************************************
// Description:
//  The menu has an option 'Do metrics' that can be
//  checked or unchecked.
//
// Usage:
//  bool bDoMetrics =TopAceMenu_Option_DoMetrics();
//
// Returns:
// TRUE when metrics shoukd be calculated
//
// ********************************************************

bool TopAceMenu_Option_DoMetrics()
{
  return g_TopAce_bDoMetrics;
}

// ********************************************************
// Description:
//  The menu has an option 'Show TopAce in graph' that can be
//  checked or unchecked.
//
// Usage:
//  bool bDoGraphTopace =TopAceMenu_Option_DoGraphTopAce();
//
// Returns:
// TRUE when the TopAce files should be shown in the graph
//
// ********************************************************

bool TopAceMenu_Option_DoGraphTopAce()
{
  return g_TopAce_bGraphTopAce;
}
