//*********************************************************
//
// Description:
//   This file adds some menu items to the 
//   TopAce subproject.
//
//   Note that we use the open source libraries
//   'Dot'. See : https://graphviz.gitlab.io/download/
//
//*****************************************************

//module:TopAce_Gedi

main()
{

  TopAceMenu_LoadMenuChoices();
  
  // we're gone make a menu item 'TopAce'
  // with some specific items to:
  // - do a full project analysis
  // - present a panel where you can analyse a folder
  int id  = moduleAddMenu("&TopAce");
  moduleAddAction("Analyse project", "", "", id, -1, "TopAceAnalyse");
  moduleAddAction("Analyse script folder", "", "", id, -1, "TopAceAnalyseScriptFolder");
  moduleAddAction("------------"              , "", "", id, -1, "dummy"); 
  moduleAddAction("Show graph", "", "", id, -1, "ta_Software_ShowSVG");
  moduleAddAction("Show diff", "", "", id, -1, "ta_Software_ShowDiff");
  moduleAddAction("------------"              , "", "", id, -1, "dummy"); 
	
  // We have some options that can be checked / unchecked
  g_TopAce_iMenuOption_Metrics = moduleAddAction( "Calculate metrics", "", "", id, -1, "TopAceMenu_StoreMenuChoices" );
  moduleSetAction( g_TopAce_iMenuOption_Metrics, "checkable", true );
  moduleSetAction( g_TopAce_iMenuOption_Metrics, "checked", g_TopAce_bDoMetrics );

  g_TopAce_iMenuOption_GraphTopAce = moduleAddAction( "Include TopAce in graph", "", "", id, -1, "TopAceMenu_StoreMenuChoices" );
  moduleSetAction( g_TopAce_iMenuOption_GraphTopAce, "checkable", true );
  moduleSetAction( g_TopAce_iMenuOption_GraphTopAce, "checked", g_TopAce_bGraphTopAce );
  
}


void ta_Software_ShowDiff()
{
  string strDisplay = PROJ_PATH + "Data/TopAceOutput/_diff.html";
  system( strDisplay );
}

// ********************************************************
// Description:
//  This is just a simple 'dummy' function
//  that we use to add a separator line to the
//  menu that we add to the Gedi.
//
// Usage:
//  See above
//
// Returns:
//  Nothing. 
//
// ********************************************************

void dummy()
{ 
}

// ********************************************************
// Description:
// Will add an item to the menu bar that is used
// to present the TopAce panel
//
// Usage:
//  See above
//
// Returns:
//  Nothing. 
//
// ********************************************************

void TopAceAnalyse()
{
  ModuleOnWithPanel(
    "TopAce", 
    100, 100, -1, -1, 1, 1, 
    "", 
    "TopAce/TopAce.pnl", 
    "",
    makeDynString( "$DOMETRICS:" + g_TopAce_bDoMetrics ));
  
}

// ********************************************************
// Description:
// Will add an item to the menu bar that is used
// to present the TopAce panel ued to 
// analyse a folder.
//
// Usage:
//  See above
//
// Returns:
//  Nothing. 
//
// ********************************************************

void TopAceAnalyseScriptFolder()
{
  ModuleOnWithPanel(
    "TopAce analyse script folder", 
    100, 100, -1, -1, 1, 1, 
    "", 
    "TopAce/Sub/Analyse_ScriptFolder.pnl", 
    "",
    makeDynString());
}

